<?php

namespace Widget\OrderBundle\Event;

use Symfony\Component\EventDispatcher\Event;
use Widget\OrderBundle\Model\Order;

class OrderStatusChangeEvent extends Event
{
    const EVENT_NAME = 'event.order.status.change';

    /** @var  Order */
    protected $order;

    protected $con;

    /**
     * @param Order $order
     * @param  $con
     */
    public function __construct($order, $con)
    {
        $this->order = $order;
        $this->con = $con;
    }


    /**
     * @return Order
     */
    public function getOrder()
    {
        return $this->order;
    }

    /**
     * @return \PropelPDO
     */
    public function getCon()
    {
        return $this->con;
    }
}