<?php

namespace Widget\OrderBundle\Controller\BackendAPI;

use Backend\BaseBundle\Controller\BackendAPI\BaseBackendAPIController;
use Backend\BaseBundle\Form\Type\APIFormTypeItem;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Method;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Security;
use Symfony\Component\HttpFoundation\Request;
use Widget\OrderBundle\Model\OrderLog;
use Widget\OrderBundle\Model\OrderLogPeer;
use Widget\OrderBundle\Model\OrderLogQuery;
use Widget\OrderBundle\Model\OrderQuery;
use Widget\OrderBundle\Model\OrderStatusQuery;

/**
 * @Route("/orderlog")
 * @Security("has_role_or_superadmin('ROLE_ORDER')")
 */
class OrderLogController extends BaseBackendAPIController
{
    /**
     * 欄位表單設定
     * 主要是USER送過來的欄位
     * @return APIFormTypeItem[]
     */
    protected function getFormConfig()
    {
        return array(
            new APIFormTypeItem("order_id"),
            new APIFormTypeItem("writer_name"),
            new APIFormTypeItem("log_comment"),
            new APIFormTypeItem("payment_status_name"),
        );
    }


    /**
     * 新增
     * @Route("s")
     * @Method({"POST"})
     * @Security("has_role_or_superadmin('ROLE_ORDER_WRITE')")
     */
    public function createAction(Request $request)
    {
        // 手動解 token 取 username
        $jwtToken = $request->headers->get('Authorization');
        preg_match('/^Bearer\s+(.*)$/i', $jwtToken, $match);
        $jwt = $this->get('secret_jwt_token');
        $tokenData = $jwt->verify($match[1], $request->getHttpHost());
        $dataRow = json_decode($request->getContent(), true);
        
        // 只改狀態 log 就空
        $logComment = "";
        if (isset($dataRow['order_log_comment'])){
            $logComment = $dataRow['order_log_comment'];
        }
        $orderStatus = OrderStatusQuery::create()->findPk($dataRow['order_status_id']);
        if ($orderStatus) {
            $paymentStatusName = $orderStatus->getName();
        }
        else {
            $paymentStatusName = "";
        }
        // 手動寫回 object
        $orderLog = new OrderLog();
        $orderLog->setOrderId($dataRow['id']);
        $orderLog->setPaymentStatusName($paymentStatusName);
        $orderLog->setLogComment($logComment);
        $orderLog->setWriterName($tokenData['login_name']);
        $orderLog->save();
        return $this->createJsonSerializeResponse($orderLog, array('detail'));
    }

    /**
     * 列出訂單的log
     * @Route("s/{orderId}/all")
     * @Method({"GET"})
     * @Security("has_role_or_superadmin('ROLE_ORDER_STATUS_READ')")
     */
    public function listAction(Request $request, $orderId)
    {
        $orderLog = OrderLogQuery::create()->filterByOrderId($orderId)->orderByCreatedAt(\Criteria::ASC)->find();
        return $this->createJsonSerializeResponse($orderLog, array('detail'));
    }
    
}