<?php
namespace Widget\OrderBundle\Tests\EventListener\ControllerConfig;
use Backend\BaseBundle\Tests\Fixture\BaseKernelTestCase;
use Widget\MemberBundle\Model\MemberQuery;
use Widget\OrderBundle\Model\OrderInfo;
use Widget\OrderBundle\Model\OrderInfoQuery;
use Widget\OrderBundle\Model\OrderQuery;
use Widget\PaymentBundle\Event\ReceiveOrderEvent;

/**
 * Created by PhpStorm.
 * User: bubble
 * Date: 2016/7/5
 * Time: 下午 6:27
 */
class OrderSendMailListenerTest extends BaseKernelTestCase
{

    /**
     * 1.測試status錯誤時是否會直接 return
     */
    public function test_onReceiveOrderStatusEvent_status_false()
    {
        //arrange
        $listener = $this->container->get('widget.order_bundle.event_listener.controller_config.order_send_mail_listener');
        $orderId = 'P0002';
        $amountForPay = 150;
        $status = false;
        $paymentInfo = '800-6521782765376';
        $event = new ReceiveOrderEvent($orderId, $amountForPay, $status, $paymentInfo);

        //act
        $listener->onReceiveOrderStatusEvent($event);

        //assert
        $this->assertTrue($event->isPropagationStopped());
    }

    /**
     * 1.測試資料正確時是否會發信
     */
    public function test_onReceiveOrderStatusEvent_valid_data_and_sand_mail()
    {
        //arrange
        $listener = $this->container->get('widget.order_bundle.event_listener.controller_config.order_send_mail_listener');
        $orderId = 'P0000';
        $amountForPay = 150;
        $status = true;
        $paymentInfo = '800-6521782765376';
        $slug = 'dgfactor';
        $orderInfo = OrderInfoQuery::create()
            ->findOneById($orderId);
        $member = MemberQuery::create()->findOneById($orderInfo->getOrder()->getMemberId());
        $data = array(
            'email' => 'bubble@dgfactor.com',
        );

        $message = $this->getMockBuilder(\Swift_Message::class)
            ->disableOriginalConstructor()
            ->setMethods(array('setSubject', 'setTo', 'setBody', '__destruct', 'setCharset', 'setContentType'))
            ->getMock();
        $message
            ->expects($this->once())
            ->method('setCharset')
            ->willReturnCallback(function($charset) use($message){
                $this->assertEquals('utf-8', $charset);
                return $message;
            });
        $message
            ->expects($this->once())
            ->method('setContentType')
            ->willReturnCallback(function($type) use($message){
                $this->assertEquals('text/html', $type);
                return $message;
            });
        $message
            ->expects($this->once())
            ->method('setSubject')
            ->willReturnCallback(function($subject) use($message, $orderId){
                $this->assertEquals("payment success:$orderId", $subject);
                return $message;
            });
        $message
            ->expects($this->once())
            ->method('setTo')
            ->willReturnCallback(function($email, $name) use($message, $orderInfo, $member){
                $this->assertEquals(array(
                    $member->getEmail(),
                    $orderInfo->getBuyerEmail()
                ), array(
                    $email[0],
                    $email[1]
                    )
                );
                $this->assertEquals(array(
                    $member->getName(),
                    $orderInfo->getBuyerName()
                ), array(
                    $name[0],
                    $name[1]
                ));
                return $message;
            });
        $message
            ->expects($this->once())
            ->method('setBody')
            ->willReturnCallback(function($content) use($message){
                $this->assertEquals("訂單編號:P0000 總金額:200 應付金額:150 繳款日期:2016-07-07 08:00:00 付款方式:AllpayVacc", $content);
                return $message;
            });
        $mailer = $this->getMockBuilder(\Swift_Mailer::class)
            ->disableOriginalConstructor()
            ->setMethods(array('send'))
            ->getMock();
        $mailer
            ->expects($this->once())
            ->method('send')
            ->willReturnCallback(function(){

            });

        $mailerService = $this->getMockBuilder(CustomMailerService::class)
            ->setMethods(array('get', 'newMessage'))
            ->getMock();
        $mailerService
            ->expects($this->once())
            ->method('get')
            ->willReturn($mailer);
        $mailerService
            ->expects($this->once())
            ->method('newMessage')
            ->willReturn($message);

        $this->setObjectAttribute($listener, 'customMailerService', $mailerService);

        $event = new ReceiveOrderEvent($orderId, $amountForPay, $status, $paymentInfo);

        //act
        $listener->onReceiveOrderStatusEvent($event);

        //assert
        $this->assertFalse($event->isPropagationStopped());
    }

    /**
     * 1.測試繳款發信
     */
    public function test_onReceivePaymentnumberEvent_valid_data_and_sand_mail()
    {
        //arrange
        $listener = $this->container->get(
            'widget.order_bundle.event_listener.controller_config.order_send_mail_listener'
        );
        $orderId = 'P0000';
        $amountForPay = 150;
        $status = true;
        $paymentInfo = '800-6521782765376';
        $slug = 'dgfactor';
        $orderInfo = OrderInfoQuery::create()
            ->findOneById($orderId);
        $member = MemberQuery::create()
            ->findOneById($orderInfo->getOrder()->getMemberId());
        $data = array(
            'email' => 'bubble@dgfactor.com',
        );

        $message = $this->getMockBuilder(\Swift_Message::class)
            ->disableOriginalConstructor()
            ->setMethods(array('setSubject', 'setTo', 'setBody', '__destruct', 'setCharset', 'setContentType'))
            ->getMock();
        $message
            ->expects($this->once())
            ->method('setCharset')
            ->willReturnCallback(function($charset) use($message){
                $this->assertEquals('utf-8', $charset);
                return $message;
            });
        $message
            ->expects($this->once())
            ->method('setContentType')
            ->willReturnCallback(function($type) use($message){
                $this->assertEquals('text/html', $type);
                return $message;
            });
        $message
            ->expects($this->once())
            ->method('setSubject')
            ->willReturnCallback(function($subject) use($message, $orderId){
                $this->assertEquals("payment success:$orderId", $subject);
                return $message;
            });
        $message
            ->expects($this->once())
            ->method('setTo')
            ->willReturnCallback(function($email, $name) use($message, $orderInfo, $member){
                $this->assertEquals(array(
                    $member->getEmail(),
                    $orderInfo->getBuyerEmail()
                ), array($email[0], $email[1]));
                $this->assertEquals(array(
                    $member->getName(),
                    $orderInfo->getBuyerName()),
                array(
                    $name[0],
                    $name[1]
                ));
                return $message;
            });
        $message
            ->expects($this->once())
            ->method('setBody')
            ->willReturnCallback(function($content) use($message){
                $this->assertEquals("訂單編號:P0000 總金額:200 應付金額:150 繳款日期:2016-07-07 08:00:00 付款方式:AllpayVacc", $content);
                return $message;
            });
        $mailer = $this->getMockBuilder(\Swift_Mailer::class)
            ->disableOriginalConstructor()
            ->setMethods(array('send'))
            ->getMock();
        $mailer
            ->expects($this->once())
            ->method('send')
            ->willReturnCallback(function(){

            });

        $mailerService = $this->getMockBuilder(CustomMailerService::class)
            ->setMethods(array('get', 'newMessage'))
            ->getMock();
        $mailerService
            ->expects($this->once())
            ->method('get')
            ->willReturn($mailer);
        $mailerService
            ->expects($this->once())
            ->method('newMessage')
            ->willReturn($message);

        $this->setObjectAttribute($listener, 'customMailerService', $mailerService);

        $event = new ReceiveOrderEvent($orderId, $amountForPay, $status, $paymentInfo);

        //act
        $listener->onReceiveOrderStatusEvent($event);

        //assert
        $this->assertFalse($event->isPropagationStopped());
    }
}