<?php
/**
 * Created by PhpStorm.
 * User: bubble
 * Date: 2016/7/13
 * Time: 下午 3:41
 */

namespace Widget\OrderBundle\Tests\EventListener\ControllerConfig;


use Backend\BaseBundle\Model\Site;
use Backend\BaseBundle\Tests\Fixture\BaseWebTestCase;
use Widget\OrderBundle\Event\OrderInvaildEvent;
use Widget\OrderBundle\Event\ReceiveOrderQueryStatusEvent;
use Widget\OrderBundle\EventListener\ControllerConfig\OrderRecoverListener;
use Widget\OrderBundle\Model\Order;
use Widget\OrderBundle\Model\OrderPeer;
use Widget\OrderBundle\Model\OrderQuery;
use Widget\OrderBundle\Model\OrderStatus;
use Widget\OrderBundle\Model\OrderStatusQuery;

class OrderRecoverListenerTest extends BaseWebTestCase
{
    public function test_onReceiveOrderQueryStatusEvent()
    {
        //arrange
        $orderStatusQuery = $this->getMockBuilder(OrderStatusQuery::class)
            ->disableOriginalConstructor()
            ->setMethods(array('filterByStatus', 'endUse'))
            ->getMock();

        $orderQuery = $this->getMockBuilder(OrderQuery::class)
            ->disableOriginalConstructor()
            ->setMethods(array('useOrderStatusQuery', 'find'))
            ->getMock();
        $orderQuery
            ->expects($this->once())
            ->method('useOrderStatusQuery')
            ->willReturn($orderStatusQuery);

        $orderStatusQuery
            ->expects($this->once())
            ->method('filterByStatus')
            ->with(true)
            ->willReturn($orderStatusQuery);

        $orderStatusQuery
            ->expects($this->once())
            ->method('endUse')
            ->willReturn($orderQuery);

        $event = new ReceiveOrderQueryStatusEvent($orderQuery);
        $listener = new OrderRecoverListener();

        //act
        $listener->onReceiveOrderQueryStatusEvent($event);
    }

    public function test_onReceiveInvalidOrderEvent()
    {
        //arrange
        $siteId = 12345;

        $con = $this->getMockBuilder(\PropelPDO::class)
            ->disableOriginalConstructor()
            ->getMock();
        $order = $this->getMockBuilder(Order::class)
            ->disableOriginalConstructor()
            ->setMethods(array('save', 'setOrderStatus', 'getSiteId'))
            ->getMock()
            ;
        $order
            ->expects($this->atLeastOnce())
            ->method('getSiteId')
            ->willReturn($siteId);
        $order
            ->expects($this->once())
            ->method('setOrderStatus')
            ->willReturnCallback(function(OrderStatus $orderStatus) use($order){
                $this->assertFalse($orderStatus->getStatus());
                $this->assertEquals($order->getSiteId(), $orderStatus->getSiteId());
                return $order;
            });
        $order
            ->expects($this->once())
            ->method('save')
            ->with($con)
            ->willReturn(1);

        $event = new OrderInvaildEvent($order, $con);
        $listener = new OrderRecoverListener();

        //act
        $listener->onReceiveInvalidOrderEvent($event);

        //assert
    }
}