<?php
namespace Widget\OrderBundle\EventListener\ControllerConfig;


use Backend\BaseBundle\Event\Controller\SetupEvent;
use Backend\BaseBundle\Form\Type\BaseFormType;
use Backend\BaseBundle\Form\Type\SubmitBackType;
use JMS\DiExtraBundle\Annotation as DI;
use Symfony\Component\EventDispatcher\EventDispatcherInterface;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Form\Extension\Core\Type\CollectionType;
use Symfony\Component\Form\Extension\Core\Type\PercentType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\Validator\Constraints\Range;
use Symfony\Component\Validator\Constraints\Regex;
use Widget\OrderBundle\Event\DiscountChainEvent;
use Widget\PostBundle\Form\Type\RichTextType;

/**
 * @DI\Service()
 */
class SetupListener
{

    /** @var  EventDispatcherInterface */
    protected $eventDispatcher;

    /**
     * @DI\InjectParams()
     */
    public function injectEventDispatcher(EventDispatcherInterface $eventDispatcher)
    {
        $this->eventDispatcher = $eventDispatcher;
    }

    /**
     * 通知信件設定
     * @DI\Observe(SetupEvent::EVENT_SETUP)
     */
    public function onSetup(SetupEvent $event)
    {
        $event->setConfig('widget_order.mail', array(
            'form' => array(
                array(
                    'Payment',
                    new BaseFormType(function(FormBuilderInterface $builder){
                        $builder
                            ->add('payment_mail_subject',
                                TextType::class,
                                array(
                                    'label' => 'form.label.setup.order.payment_mail_subject',
                                    'required' => true,
                                )
                            )
                            ->add('payment_mail',
                                RichTextType::class,
                                array(
                                    'label' => 'form.label.setup.order.payment_mail',
                                    'required' => true,
                                )
                            )
                        ;
                    }, 'Payment'),
                    array(
                        'label' => 'form.label.setup.order.mail.payment',
                        'required' => false,
                    ),
                ),
                array(
                    'PaymentSuccess',
                    new BaseFormType(function(FormBuilderInterface $builder){
                        $builder
                            ->add('payment_success_mail_subject',
                                TextType::class,
                                array(
                                    'label' => 'form.label.setup.order.payment_success_mail_subject',
                                    'required' => true,
                                )
                            )
                            ->add('payment_success_mail',
                                RichTextType::class,
                                array(
                                    'label' => 'form.label.setup.order.payment_success_mail',
                                    'required' => true,
                                )
                            )
                        ;
                    }, 'PaymentSuccess'),
                    array(
                        'label' => 'form.label.setup.order.mail.payment_success',
                        'required' => false,
                    ),
                ),
                array(
                    'statusChange',
                    new BaseFormType(function(FormBuilderInterface $builder){
                        $builder
                            ->add('status_change_mail_subject',
                                TextType::class,
                                array(
                                    'label' => 'form.label.setup.order.status_change_mail_subject',
                                    'required' => true,
                                )
                            )
                            ->add('status_change_mail',
                                RichTextType::class,
                                array(
                                    'label' => 'form.label.setup.order.status_change_mail',
                                    'required' => true,
                                )
                            )
                        ;
                    }, 'statusChange'),
                    array(
                        'label' => 'form.label.setup.order.mail.status_change',
                        'required' => false,
                    ),
                ),
                array(
                    'submit',
                    SubmitBackType::class,
                    array(
                        'with_back' => false,
                        'with_reset' => true,
                    ),
                ),
            ),
        ));
    }
}