<?php
namespace Widget\OrderBundle\EventListener\ControllerConfig;

use Backend\BaseBundle\Event\Controller\ConfigEvent;
use Backend\BaseBundle\Event\Controller\MenuEvent;
use Backend\BaseBundle\Event\Controller\TypeRolesEvent;
use Backend\BaseBundle\Form\Type\SubmitBackType;
use JMS\DiExtraBundle\Annotation as DI;
use JMS\DiExtraBundle\Annotation\InjectParams;
use Symfony\Component\EventDispatcher\EventDispatcherInterface;
use Symfony\Component\Routing\Router;
use Symfony\Component\Validator\Constraints\NotBlank;
use Symfony\Component\Form\Extension\Core\Type as BaseType;


/**
 * @DI\Service()
 */
class OrderStatusListener
{
    const CONTROLLER_NAME = 'WidgetOrderBundle:Backend/OrderStatus';

    /** @var  Router */
    protected $router;


    /**
     * 注入router服務
     * @InjectParams()
     */
    public function injectRouter(Router $router)
    {
        $this->router = $router;
    }

    /**
     * 注入選單服務
     * @DI\Observe(MenuEvent::EVENT_MENU)
     */
    public function onMenu(MenuEvent $event)
    {
        $user = $event->getUser();
        // 驗證是否有權限
        if(!$user->hasRoleOrSuperAdmin('ROLE_ORDER')) {
            return;
        }

        $isStatusActive = preg_match('/^widget_order_backend_orderstatus_/i', $event->getRequestRouteName());
        $slug = $user->getSiteSlug();
        $event->addMenu(self::CONTROLLER_NAME, array(
            'menu.order' => array(
                'class' => 'fa fa-shopping-cart',
                'active' => $isStatusActive,
                'target' => array(
                    'menu.order_status' => array(
                        'class' => 'fa fa-shopping-cart',
                        'active' => $isStatusActive,
                        'target' => $this->router->generate('widget_order_backend_orderstatus_index', array('slug' => $slug)),
                    ),
                ),
            ),
        ));
    }

    /**
     * 讓帳號管理介面加入權限設定
     * @DI\Observe(TypeRolesEvent::EVENT_TYPE_ROLES)
     */
    public function onTypeRoles(TypeRolesEvent $event)
    {
        $event->addTypeRoles('ROLE_ORDER_STATUS', array(
            'ROLE_ORDER_STATUS_READ',
            'ROLE_ORDER_STATUS_WRITE',
        ));
    }

    /**
     * @DI\Observe(ConfigEvent::EVENT_CONFIG)
     */
    public function onConfig(ConfigEvent $event)
    {
        if($event->getControllerName() != self::CONTROLLER_NAME){
            return;
        }
        $event->setConfig(array(
            'route' => array(
                'index' => true,
                'sort' => true,
                'new' => true,
                'edit' => true,
                'search' => true,
                'delete' => true,
            ),
            'index' => array(
                'index.order_status.id' => 'Id',
                'index.order_status.name'=>'Name',
                'index.order_status.created_at' => 'CreatedAt',
                'index.order_status.updated_at' => 'UpdatedAt',
            ),
            'security' => array(
                'new' => 'ROLE_ORDER_STATUS_WRITE',
                'view' => 'ROLE_ORDER_STATUS_READ',
                'edit' => 'ROLE_ORDER_STATUS_WRITE',
                'delete' => 'ROLE_ORDER_STATUS_WRITE',
            ),
            'search' => array(
                array(
                    'Name',
                    BaseType\TextType::class,
                    array(
                        'label' => 'index.order_status.name',
                        'required' => true,
                        'constraints' => array(
                            new NotBlank(),
                        ),
                    ),
                ),
            ),
            'action' => array(
                'action.edit' => array(
                    'class' => 'fa fa-pencil-square-o',
                    'action' => 'edit'
                ),
                'action.delete' => array(
                    'class' => 'fa fa-trash',
                    'action' => 'delete',
                    'confirm' => 'message.confirm.delete',
                ),
            ),
            'form' => array(
                array(
                    'Name',
                    BaseType\TextType::class,
                    array(
                        'label' => 'index.order_status.name',
                        'required' => true,
                        'constraints' => array(
                            new NotBlank(),
                        ),
                    ),
                ),
                array(
                    'Status',
                    BaseType\ChoiceType::class,
                    array(
                        'label' => 'index.order.status',
                        'choices' => array(
                            true => 'form.choice.valid',
                            false => 'form.choice.invalid',
                        ),
                        'expanded' => true,
                        'required' => true,
                        'constraints' => array(
                            new NotBlank(),
                        ),
                    ),
                ),

                array(
                    'DefaultStatus',
                    BaseType\ChoiceType::class,
                    array(
                        'label' => 'index.order.default_status',
                        'choices' => array(
                            true => 'form.choice.yes',
                            false => 'form.choice.no',
                        ),
                        'expanded' => true,
                        'required' => true,
                        'constraints' => array(
                            new NotBlank(),
                        ),
                    ),
                ),
                array(
                    'submit',
                    SubmitBackType::class,
                    array(
                        'with_back' => true,
                        'with_reset' => true,
                        'back_route' => 'widget_order_backend_orderstatus_index',
                    ),
                )
            ),
        ));
    }


}