<?php
namespace Widget\OrderBundle\Event;

use Symfony\Component\EventDispatcher\Event;

class ProductAddEvent extends Event
{
    const EVENT_NAME = 'event.product.add';

    protected $id;
    protected $count;

    /** @var \PropelPDO  */
    protected $con;

    protected $productName;
    protected $productPrice;
    protected $error;
    protected $siteId;

    public function __construct($id, $count, $siteId, \PropelPDO $con = null)
    {
        $this->id = $id;
        $this->count = $count;
        $this->con = $con;
        $this->siteId = $siteId;
    }

    public function setError($reason)
    {
        $this->error = $reason;
    }

    public function getId()
    {
        return $this->id;
    }

    public function getCount()
    {
        return $this->count;
    }

    public function getConnection()
    {
        return $this->con;
    }

    /**
     * @param string $productName
     * @return ProductAddEvent
     */
    public function setProductName($productName)
    {
        $this->productName = $productName;
        return $this;
    }

    /**
     * @return string
     */
    public function getProductName()
    {
        return $this->productName;
    }

    /**
     * @param integer $productPrice
     * @return ProductAddEvent
     */
    public function setProductPrice($productPrice)
    {
        $this->productPrice = $productPrice;
        return $this;
    }

    /**
     * @return integer
     */
    public function getProductPrice()
    {
        return $this->productPrice;
    }

    /**
     * @return mixed
     */
    public function getError()
    {
        return $this->error;
    }

    /**
     * @return mixed
     */
    public function getSiteId()
    {
        return $this->siteId;
    }


}