<?php
namespace Widget\OrderBundle\Event;


use Symfony\Component\EventDispatcher\Event;
use Widget\OrderBundle\Service\DiscountBuilder;

class DiscountChainEvent extends Event
{
    const EVENT_NAME = 'event.discount.chains';

    /** @var DiscountBuilder  */
    protected $discountBuilder;

    protected $siteId;

    public function __construct(DiscountBuilder $discountBuilder, $siteId)
    {
        $this->discountBuilder = $discountBuilder;
        $this->siteId = $siteId;
    }

    /**
     * @return DiscountBuilder
     */
    public function getDiscountBuilder()
    {
        return $this->discountBuilder;
    }

    /**
     * @return mixed
     */
    public function getSiteId()
    {
        return $this->siteId;
    }


}