<?php
namespace Widget\OrderBundle\Controller\Backend;

use Backend\BaseBundle\Controller\BaseController;
use JMS\DiExtraBundle\Annotation\Inject;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Security;
use Symfony\Component\EventDispatcher\EventDispatcherInterface;
use Widget\OrderBundle\Event\ReceiveCreateOrderEvent;
use Widget\OrderBundle\Model\Order;
use Widget\OrderBundle\Model\OrderLog;
use Widget\OrderBundle\Model\OrderPeer;

/**
 * @Route("/order") 註冊URL
 * @Security("has_role_or_superadmin('ROLE_ORDER')") 設定權限
 */
class OrderController extends BaseController
{
    /**
     * @Inject()
     * @var EventDispatcherInterface
     */
    protected $eventDispatcher;

    /**
     * 使用basecontroller裡面的function
     * 1. 判斷是否有變更狀態、是否備註欄位不為空
     * 2. new一個新的orderlog來新增
     * 3. setOrder需用setorder才有關聯，用setOrderId不會關聯
     * 4. 這邊不用特地去save，修改時按確定鈕則會統一save
     */
    public function updateData($form)
    {
        $con = \Propel::getConnection();
        /** @var Order $order */
        $order = $form->getData();
        if($order->isColumnModified(OrderPeer::ORDER_STATUS_ID) || $order->getOrderLogComment() != null){
            $writer_name = $this->getUser()->getUsername();
            $orderLogs = new OrderLog();
            $orderLogs->setOrder($order)
                ->setWriterName($writer_name)
                ->setLogComment($order->getOrderLogComment())
                ->setPaymentStatusName($order->getOrderStatus()->getName());
        }
        parent::updateData($form); // TODO: Change the autogenerated stub
    }
}