<?php
namespace Widget\OrderBundle\Command;
use Symfony\Bundle\FrameworkBundle\Command\ContainerAwareCommand;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;
use Widget\OrderBundle\Event\OrderInvaildEvent;
use Widget\OrderBundle\Event\ReceiveOrderQueryStatusEvent;
use Widget\OrderBundle\Model\OrderQuery;

/**
 * Created by PhpStorm.
 * User: bubble
 * Date: 2016/7/13
 * Time: 下午 6:25
 */
class OrderExpireCommand extends ContainerAwareCommand
{
    protected function configure()
    {
        $this
            ->setName('dgfactor:order:expire')
            ->setDescription('建立排程')
            ->setHelp(<<<EOT
The <info>dgfactor:order:expire</info> 建立訂單過期作廢回收排程:

  <info>php app/console dgfactor:order:expire dgfactor</info>
EOT
            );
    }

    /**
     * @see Command
     */
    protected function execute(InputInterface $input, OutputInterface $output)
    {
        $dispatcher = $this->getContainer()->get('event_dispatcher');

        $query = OrderQuery::create();
        $event = new ReceiveOrderQueryStatusEvent($query);

        $dispatcher->dispatch($event::EVENT_NAME, $event);
        if(!$event->isProcessed()){
            return;
        }

        $query = $event->getQuery();
        $con = \Propel::getConnection();
        $con->query("SET TRANSACTION ISOLATION LEVEL SERIALIZABLE;");
        foreach($query->find() as $order) {
            $con->beginTransaction();
            $odrerExpiredEvent = new OrderInvaildEvent($order, $con);
            $dispatcher->dispatch($odrerExpiredEvent::EVENT_NAME, $odrerExpiredEvent);
            $con->commit();
        }
    }
}