<?php
namespace Widget\OrderBundle\Service;

use JMS\DiExtraBundle\Annotation as DI;
use Symfony\Component\EventDispatcher\EventDispatcherInterface;
use Widget\OrderBundle\Model\Order;
use Widget\OrderBundle\Service\Discount\DiscountInterface;

/**
 * @DI\Service("widget.order_bundle.discount_builder")
 */
class DiscountBuilder
{
    /** @var DiscountInterface[] */
    protected $discounts = array();

    /** @var DiscountInterface[]  */
    protected $excludeDiscounts = array();

    /** @var  EventDispatcherInterface */
    protected $eventDispatcher;

    /**
     * @DI\InjectParams()
     */
    public function injectEventDispatcher(EventDispatcherInterface $eventDispatcher)
    {
        $this->eventDispatcher = $eventDispatcher;
    }

    /*
     * 加入優惠折扣（互不影響）
     */
    public function add(DiscountInterface $discount)
    {
        $this->discounts[] = $discount;
        return $this;
    }

    /*
     * 加入優惠折扣（互斥關係）
     */
    public function addExclude(DiscountInterface $discount)
    {
        $this->excludeDiscounts[] = $discount;
        return $this;
    }

    public function run(Order $order, \PropelPDO $con = null)
    {
        $this->runExcludeDiscounts($order, $con);
        $this->runDiscounts($order, $con);
    }

    protected function runExcludeDiscounts(Order $order, \PropelPDO $con = null)
    {
        foreach ($this->excludeDiscounts as $discount) {
            $discount->process($order, $con);
            if ($discount->isProcessed()) {
                break;
            }
        }
    }

    protected function runDiscounts(Order $order, \PropelPDO $con = null)
    {
        foreach ($this->discounts as $discount) {
            $discount->process($order, $con);
        }
    }

}