<?php
namespace Widget\OrderBundle\Service\Discount;


use Backend\BaseBundle\SiteConfig\SiteConfigBuilder;
use JMS\DiExtraBundle\Annotation as DI;
use Widget\OrderBundle\Event\DiscountChainEvent;
use Widget\OrderBundle\Model\Order;
use Widget\OrderBundle\Model\OrderItem;

class DiscountShipment extends AbstractDiscount
{
    /** @var  SiteConfigBuilder */
    protected $configBuilder;
    
    protected $siteId;

    /**
     * @DI\Observe(DiscountChainEvent::EVENT_NAME)
     */
    public function onQueryChain(DiscountChainEvent $event)
    {
        $event->addChain('shipment', 'form.choice.discount_config.shipment');
    }

    /**
     * @DI\InjectParams({
     *    "configBuilder" = @DI\Inject("backend_base.site_config_builder"),
     * })
     */
    public function injectConfigBuilder(SiteConfigBuilder $configBuilder)
    {
        $this->configBuilder = $configBuilder;
    }

    public function process(Order $order, \PropelPDO $con = null)
    {
        $siteConfig = $this->configBuilder->build($this->siteId);

        if(!($config = $siteConfig->get('widget_order.discount')) || !isset($config['DiscountShipment']) || !isset($config['DiscountShipment']['full_amount'])){
            return;
        }
        
        $this->processed = true;

        if ($order->getAmountForPay() >= $config['DiscountShipment']['full_amount']) {
            //未有運費金額，目前先寫死為100（還須判斷如果有運費項目，才需要執行此部份）
            $discount = -100;
            $orderItem = new OrderItem();
            $orderItem
                ->setQuantity(1)
                ->setUnitPrice($discount)
                ->setProductName("free shipment discount")
                ->setOrder($order);
            //同步金額
            $order->syncAmount($con);
        }
        
    }
}