<?php
/**
 * Created by PhpStorm.
 * User: bubble
 * Date: 2016/7/12
 * Time: 下午 6:27
 */

namespace Widget\OrderBundle\EventListener\ControllerConfig;


use JMS\DiExtraBundle\Annotation as DI;
use JMS\Serializer\Tests\Fixtures\Order;
use Widget\OrderBundle\Event\OrderInvaildEvent;
use Widget\OrderBundle\Event\ReceiveOrderQueryStatusEvent;
use Widget\OrderBundle\Model\OrderPeer;
use Widget\OrderBundle\Model\OrderStatusQuery;

/**
 * @DI\Service()
 */
class OrderRecoverListener
{
    /**
     * @DI\Observe(ReceiveOrderQueryStatusEvent::EVENT_NAME)
     * 這邊負責會下query查詢有效的訂單
     */
    public function onReceiveOrderQueryStatusEvent(ReceiveOrderQueryStatusEvent $event)
    {
        $event->getQuery()
            ->useOrderStatusQuery()
                ->filterByStatus(true)
            ->endUse()
            ->find();

    }

    /**
     * @DI\Observe(OrderInvaildEvent::EVENT_NAME, priority = -10))
     * 作廢訂單
     */
    public function onReceiveInvalidOrderEvent(OrderInvaildEvent $event)
    {
        $order = $event->getOrder();
        $orderStatus = OrderStatusQuery::create()
            ->filterBySiteId($order->getSiteId())
            ->findOneByStatus(false);
        if(!$orderStatus){
            return;
        }
        $order->setOrderStatus($orderStatus);
        $order->save($event->getConnection());
    }
}