<?php
/**
 * Created by PhpStorm.
 * User: bubble
 * Date: 2016/7/13
 * Time: 下午 2:12
 */

namespace Widget\OrderBundle\Event;


use Symfony\Component\EventDispatcher\Event;
use Widget\OrderBundle\Model\Order;

class OrderInvaildEvent extends Event
{
    const EVENT_NAME = 'event.order.invaild';

    /** @var Order  */
    protected $order;

    /** @var \PropelPDO  */
    protected $connection;

    public function __construct(Order $order, \PropelPDO $con = null)
    {
        $this->order = $order;
        $this->connection = $con;
    }

    /**
     * @return Order
     */
    public function getOrder()
    {
        return $this->order;
    }

    /**
     * @return \PropelPDO
     */
    public function getConnection()
    {
        return $this->connection;
    }


}