<?php

namespace Widget\OrderBundle\Event;


use Symfony\Component\EventDispatcher\Event;
use Widget\OrderBundle\Model\Order;

class OrderFinishEvent extends Event
{
    const EVENT_NAME = 'event.order.finish';
    
    protected $order;
    
    protected $con;
    
    protected $parameters;


    public function __construct(Order $order, \PropelPDO $con = null, $parameters = array())
    {
        $this->order = $order;
        $this->con = $con;
        $this->parameters = $parameters;
    }

    /**
     * @return Order
     */
    public function getOrder()
    {
        return $this->order;
    }

    /**
     * @return \PropelPDO
     */
    public function getCon()
    {
        return $this->con;
    }

    /**
     * @return array
     */
    public function getParameters()
    {
        return $this->parameters;
    }
}