<?php
/**
 * Created by PhpStorm.
 * User: bubble
 * Date: 2016/8/18
 * Time: 下午 6:10
 */

namespace Widget\OrderBundle\Controller\Backend;

use Backend\BaseBundle\Controller\BaseController;
use JMS\DiExtraBundle\Annotation\Inject;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Method;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Symfony\Component\EventDispatcher\EventDispatcherInterface;
use Symfony\Component\HttpFoundation\Request;
use Widget\OrderBundle\Event\ReceiveCreateOrderEvent;
use Widget\OrderBundle\Model\Order;

/**
 * @Route("/sendmail")
 */
class OrderSendMailController extends BaseController
{
    /**
     * @Inject()
     * @var EventDispatcherInterface
     */
    protected $eventDispatcher;

    /**
     * @Route("/{id}/send")
     * @Method("GET")
     */
    public function sendMailAction(Order $order, Request $request)
    {
        $receiveCreatOrder = new ReceiveCreateOrderEvent($order);
        $this->eventDispatcher->dispatch(ReceiveCreateOrderEvent::EVENT_NAME, $receiveCreatOrder);
        $this->addFlash('success', 'message.success.sendmail');
        return $this->redirect($request->headers->get('referer'));
    }
}