<?php
namespace Widget\MemberBundle\Token;

use Backend\BaseBundle\Token\Service\TokenRequest\TokenRequestInterface;
use Widget\MemberBundle\Model\Member;

class MemberTokenRequest implements TokenRequestInterface
{
    const TOKEN_TYPE = 'member';
    const TTL = 3600;

    /** @var Member  */
    protected $member;

    public function __construct(Member $member)
    {
        $this->member = $member;
    }

    public function getId()
    {
        return $this->member->getId();
    }

    public function getType()
    {
        return self::TOKEN_TYPE;
    }

    public function getPayload()
    {
        return array();
    }

    public function getData()
    {
        return array();
    }

    public function getTtl()
    {
        return self::TTL;
    }
}