<?php
namespace Widget\MemberBundle\Test\Token;

use Backend\BaseBundle\Tests\Fixture\BaseTestCase;
use Backend\BaseBundle\Token\Service\TokenRequest\TokenRequestInterface;
use Widget\MemberBundle\Model\Member;
use Widget\MemberBundle\Token\MemberTokenRequest;

class MemberTokenRequestTest extends BaseTestCase
{
    public function test_is_a()
    {
        //arrange
        $memberId = '12345';
        $member = new Member();
        $member->setId($memberId);

        //act
        $memberTokenRequest = new MemberTokenRequest($member);

        //assert
        $this->assertInstanceOf(TokenRequestInterface::class, $memberTokenRequest);
    }

    public function test_getId()
    {
        //arrange
        $memberId = '12345';
        $member = new Member();
        $member->setId($memberId);
        $memberTokenRequest = new MemberTokenRequest($member);

        //act
        $result = $memberTokenRequest->getId();

        //assert
        $this->assertEquals($memberId, $result);
    }

    public function test_getType()
    {
        //arrange
        $memberId = '12345';
        $member = new Member();
        $member->setId($memberId);
        $memberTokenRequest = new MemberTokenRequest($member);

        //act
        $result = $memberTokenRequest->getType();

        //assert
        $this->assertEquals('member', $result);
    }

    public function test_getPayload()
    {
        //arrange
        $memberId = '12345';
        $member = new Member();
        $member->setId($memberId);
        $memberTokenRequest = new MemberTokenRequest($member);

        //act
        $result = $memberTokenRequest->getPayload();

        //assert
        $this->assertEquals(array(), $result);
    }

    public function test_getData()
    {
        //arrange
        $memberId = '12345';
        $member = new Member();
        $member->setId($memberId);
        $memberTokenRequest = new MemberTokenRequest($member);

        //act
        $result = $memberTokenRequest->getData();

        //assert
        $this->assertEquals(array(), $result);
    }

    public function test_getTtl()
    {
        //arrange
        $memberId = '12345';
        $member = new Member();
        $member->setId($memberId);
        $memberTokenRequest = new MemberTokenRequest($member);

        //act
        $result = $memberTokenRequest->getTtl();

        //assert
        $this->assertEquals(3600, $result);
    }
}