<?php
namespace Widget\MemberBundle\Tests\Service;


use Backend\BaseBundle\Tests\Fixture\BaseTestCase;
use Symfony\Component\EventDispatcher\EventDispatcher;
use Widget\MemberBundle\Event\TokenSignEvent;
use Widget\MemberBundle\Model\Member;
use Widget\MemberBundle\Service\TokenService;

class TokenServiceTest extends BaseTestCase
{
    public function test_injectSecret()
    {
        //arrange
        $secret = 'abcdefg';
        $service = new TokenService();

        //act
        $service->injectSecret($secret);

        //assert
        $this->assertEquals($secret, $this->getObjectAttribute($service, 'secret'));
    }

    public function test_injectEventDispatcher()
    {
        //arrange
        $eventDispatcher = $eventDispatcher = $this->getMockBuilder(EventDispatcher::class)
            ->disableOriginalConstructor()
            ->getMock();
        $service = new TokenService();

        //act
        $service->injectEventDispatcher($eventDispatcher);

        //assert
        $this->assertEquals($eventDispatcher, $this->getObjectAttribute($service, 'eventDispatcher'));
    }

    public function test_sign()
    {
        //arrange
        $memberId = '12345';
        $memberName = 'ricky';
        $memberEmail = 'ricky@dgfactor.com';
        $issuer = 'test_issuer';
        $audience = 'test_audience';
        $secret = 'abcdefg';
        $member = new Member();
        $member
            ->setId($memberId)
            ->setName($memberName)
            ->setEmail($memberEmail)
            ;
        $eventDispatcher = $this->getMockBuilder(EventDispatcher::class)
            ->setMethods(array('dispatch'))
            ->disableOriginalConstructor()
            ->getMock();
        $eventDispatcher
            ->expects($this->once())
            ->method('dispatch')
            ->willReturnCallback(function($eventName, TokenSignEvent $event) use($member){
                $this->assertEquals(TokenSignEvent::EVENT_NAME, $eventName);
                $this->assertEquals($member, $event->getMember());
                $event->appendData('k1', 'v1');
                $event->appendData('k2', 'v2');
            });

        $service = new TokenService();
        $this->setObjectAttribute($service, 'secret', $secret);
        $this->setObjectAttribute($service, 'eventDispatcher', $eventDispatcher);

        //act
        $result = $service->sign($issuer, $audience, $member);

        //assert
        $data = $result->getClaim('data');
        $this->assertNotEmpty($result);
        $this->assertEquals('v1', $data['k1']);
        $this->assertEquals('v2', $data['k2']);
    }
}