<?php

namespace Widget\MemberBundle\Tests\Service;

use Backend\BaseBundle\Tests\Fixture\BaseWebTestCase;
use Widget\MemberBundle\Model\GroupQuery;
use Widget\MemberBundle\Model\Member;
use Widget\MemberBundle\Model\MemberQuery;
use Widget\MemberBundle\Service\DefaultGroupService;

class DefaultGroupServiceTest extends BaseWebTestCase
{
    public function test_injectConfig()
    {
        // arrange
        $defaultGroup = new DefaultGroupService();
        $expectGroupName = "group1";

        // act
        $config = $this->callObjectMethod($defaultGroup, 'memberConfig');

        // assert
        $this->assertEquals($expectGroupName, $config['config']['DefaultGroup']);
    }
    
    public function test_setDefaultGroup()
    {
        // arrange
        $defaultGroup = new DefaultGroupService();
        // 取一個沒設群組的會員
        $member = MemberQuery::create()->findPk(1009);
        $group = GroupQuery::create()->filterByName('group1')->findOne();

        // act
        $defaultGroup->setMemberDefaultGroup($member);
        $memberGroups = $member->getGroups()->toArray();

        // assert
        $this->assertEquals($group->getId(), $memberGroups[0]['Id']);
        $this->assertEquals($group->getName(), $memberGroups[0]['Name']);

        $member->removeGroup($group)->save();

    }

    public function test_no_setDefaultGroup_no_config()
    {
        // arragne
        $defaultGroupService = $this->getMockBuilder(DefaultGroupService::class)
            ->disableOriginalConstructor()
            ->setMethods(array('memberConfig'))
            ->getMock();

        $defaultGroupService
            ->method('memberConfig')
            ->willReturn(array('config' => array('DefaultGroup' => array())));

        $member = MemberQuery::create()->findPk(1009);

        // act
        $defaultGroupService->setMemberDefaultGroup($member);

        // assert
        $group = GroupQuery::create()->filterByName(DefaultGroupService::DEFAULT_GROUP_NAME)->findOne();

        // act
        $member = MemberQuery::create()->findPk(1009);
        $memberGroups = $member->getGroups()->toArray();

        // assert
        $this->assertEquals($group->getId(), $memberGroups[0]['Id']);
        $this->assertEquals($group->getName(), $memberGroups[0]['Name']);

        $member->removeGroup($group)->save();
        $group->delete();
    }
    
}