<?php
namespace Widget\MemberBundle\Tests\Security;


use Backend\BaseBundle\Tests\Fixture\BaseKernelTestCase;
use Widget\MemberBundle\Model\Member;
use Widget\MemberBundle\Security\MemberPasswordEncoderFactory;
use Widget\MemberBundle\Service\DefaultGroupService;

class SoldiumMemberManagerTest extends BaseKernelTestCase
{
    public function test_inject()
    {
        //arrange

        //act
        $memberManager = $this->container->get('member_manager.soldium_password');

        //assert
        $this->assertInstanceOf(DefaultGroupService::class, $this->getObjectAttribute($memberManager, 'defaultGroupService'));
        $this->assertInstanceOf(MemberPasswordEncoderFactory::class, $this->getObjectAttribute($memberManager, 'encoderFactory'));
    }

    public function test_updatePassword()
    {
        //arrange
        $memberManager = $this->container->get('member_manager.soldium_password');
        $member = new Member();
        $member->setPlainPassword('test123')->setPassword(null)->setSalt(null);

        //act
        $this->callObjectMethod($memberManager, 'updatePassword', $member);

        //assert
        $this->assertStringStartsWith('$argon2i', $member->getPassword());
    }

    public function test_verifyPassword()
    {
        //arrange
        $memberManager = $this->container->get('member_manager.soldium_password');
        $hashPassword = '$2a$10$P68fk4jspOp2VQ4MrzYpL.wdph0KwoJic8z0efFjRuV.ZxKB0Oe/S';
        $originPassword = '123qweasd';
        $member = new Member();
        $member->setPassword($hashPassword);

        //act
        $result = $this->callObjectMethod($memberManager, 'verifyPassword', $member, $originPassword);

        //assert
        $this->assertTrue($result);
    }
}