<?php
namespace Widget\MemberBundle\Tests\Security;

use Backend\BaseBundle\Tests\Fixture\BaseKernelTestCase;
use Widget\MemberBundle\Security\MemberPasswordEncoderFactory;
use Widget\MemberBundle\Security\MemberSoldiumPassword as Password;

class MemberPasswordEncoderFactoryTest extends BaseKernelTestCase
{
    public function test_injectAlgorithm()
    {
        //arrange
        $algorithm = 'Blowfish';
        $factory = new MemberPasswordEncoderFactory();

        //act
        $factory->injectAlgorithm($algorithm);

        //assert
        $this->assertEquals(Password::BLOWFISH, $this->getObjectAttribute($factory, 'type'));
    }

    public function test_di()
    {
        //arrange
        $type = Password::SODIUM_ARGON2;

        //act
        $factory = $this->container->get('member_password_encoder_factory');

        //assert
        $this->assertEquals($type, $this->getObjectAttribute($factory, 'type'));
    }

    public function test_getEncoder()
    {
        //arrange
        $type = Password::SODIUM_ARGON2;
        $factory = $this->container->get('member_password_encoder_factory');

        //act
        $encoder = $factory->getEncoder();

        //assert
        $this->assertInstanceOf(Password::class, $encoder);
        $this->assertEquals($type, $encoder->getType());
    }
}