<?php
namespace Widget\MemberBundle\Tests\Model;

use Widget\MemberBundle\Model;
use Backend\BaseBundle\Security\SecurityEncoderInterface;
use Backend\BaseBundle\Tests\Fixture\BaseTestCase;

/**
 * @group unit
 */
class MemberTest extends BaseTestCase
{
    public function test_is_a_SecurityEncoderInterface()
    {
        //arrange
        //act
        $member = new Model\Member();

        //assert
        $this->assertInstanceOf(SecurityEncoderInterface::class, $member);
    }


    public function test_setPlainPassword()
    {
        //arrange
        $member = new Model\Member();

        //act
        $member->setPlainPassword('plain_password');

        //assert
        $this->assertEquals('plain_password', $this->getObjectAttribute($member, 'plainPassword'));
    }

    public function test_getPlainPassword()
    {
        //arrange
        $member = new Model\Member();

        //act
        $member->setPlainPassword('plain_password');

        //assert
        $this->assertEquals('plain_password', $member->getPlainPassword());
    }

    public function test_regenerateSalt()
    {
        //arrange
        $member = new Model\Member();

        //act
        $member->regenerateSalt();

        //assert
        $this->assertNotNull($member->getSalt());
    }
}