<?php
namespace Widget\MemberBundle\Tests\EventListener;
use Backend\BaseBundle\Tests\Fixture\BaseKernelTestCase;
use Backend\BaseBundle\Token\Service\ShaTokenService;
use Backend\BaseBundle\Token\Service\Token;
use Backend\BaseBundle\Token\Service\TokenServiceInterface;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpKernel\Event\GetResponseEvent;
use Symfony\Component\HttpKernel\HttpKernel;
use Widget\MemberBundle\EventListener\MemberTokenListener;
use Widget\MemberBundle\Token\MemberTokenRequest;


/**
 * @group units
 */
class MemberTokenListenerTest extends BaseKernelTestCase
{
    public function test_EventHook()
    {
        //arrange
        $count = 0;
        $eventDispatcher = $this->container->get('event_dispatcher');
        $listeners = $eventDispatcher->getListeners("kernel.request");

        //act
        foreach($listeners as $listener){
            if(is_array($listener) && $listener[0] instanceof MemberTokenListener){
                $count++;
                $this->assertInstanceOf(TokenServiceInterface::class, $this->getObjectAttribute($listener[0], 'tokenService'));
            }
        }

        //assert
        $this->assertEquals(1, $count);
    }

    public function test_onRequest_not_masterRequest()
    {
        //arrange
        $jwtToken = 'aaa.bbb.ccc';
        $token = $this->getMockBuilder(Token::class)->disableOriginalConstructor()->getMock();

        $request = new Request();
        $request->headers->set('Authorization', "Bearer $jwtToken");
        $tokenService = $this->getMockBuilder(ShaTokenService::class)
            ->setMethods(array('parse'))
            ->getMock();
        $tokenService
            ->expects($this->any())
            ->method('parse')
            ->with($jwtToken)
            ->willReturn($token);
        $event = $this->getMockBuilder(GetResponseEvent::class)
            ->setMethods(array('getRequest', 'getRequestType'))
            ->disableOriginalConstructor()
            ->getMock();
        $event
            ->expects($this->any())
            ->method('getRequestType')
            ->willReturn(HttpKernel::SUB_REQUEST);
        $event
            ->expects($this->any())
            ->method('getRequest')
            ->willReturn($request);
        $listener = new MemberTokenListener();

        //act
        $listener->onRequest($event);

        //assert
        $this->assertNull($request->attributes->get('_authorizedToken'));
    }

    public function test_onRequest_no_Authorization_header()
    {
        //arrange
        $jwtToken = 'aaa.bbb.ccc';
        $token = $this->getMockBuilder(Token::class)->disableOriginalConstructor()->getMock();

        $request = new Request();
//        $request->headers->set('Authorization', "Bearer $jwtToken");
        $tokenService = $this->getMockBuilder(ShaTokenService::class)
            ->setMethods(array('parse'))
            ->getMock();
        $tokenService
            ->expects($this->any())
            ->method('parse')
            ->with($jwtToken)
            ->willReturn($token);
        $event = $this->getMockBuilder(GetResponseEvent::class)
            ->setMethods(array('getRequest', 'getRequestType'))
            ->disableOriginalConstructor()
            ->getMock();
        $event
            ->expects($this->any())
            ->method('getRequestType')
            ->willReturn(HttpKernel::MASTER_REQUEST);
        $event
            ->expects($this->any())
            ->method('getRequest')
            ->willReturn($request);
        $listener = new MemberTokenListener();

        //act
        $listener->onRequest($event);

        //assert
        $this->assertNull($request->attributes->get('_authorizedToken'));
    }

    public function test_onRequest_token_parse_fail()
    {
        //arrange
        $jwtToken = 'aaa.bbb.ccc';
        $token = $this->getMockBuilder(Token::class)->disableOriginalConstructor()->getMock();

        $request = new Request();
        $request->headers->set('Authorization', "Bearer $jwtToken");
        $tokenService = $this->getMockBuilder(ShaTokenService::class)
            ->setMethods(array('parse'))
            ->getMock();
        $tokenService
            ->expects($this->any())
            ->method('parse')
            ->with($jwtToken)
            ->willReturn(null);

        $event = $this->getMockBuilder(GetResponseEvent::class)
            ->setMethods(array('getRequest', 'getRequestType'))
            ->disableOriginalConstructor()
            ->getMock();
        $event
            ->expects($this->any())
            ->method('getRequestType')
            ->willReturn(HttpKernel::MASTER_REQUEST);
        $event
            ->expects($this->any())
            ->method('getRequest')
            ->willReturn($request);
        $listener = new MemberTokenListener();
        $this->setObjectAttribute($listener, 'tokenService', $tokenService);

        //act
        $listener->onRequest($event);

        //assert
        $this->assertNull($request->attributes->get('_authorizedToken'));
    }

    public function test_onRequest_token_parse_bad_type()
    {
        //arrange
        $jwtToken = 'aaa.bbb.ccc';
        $token = $this->getMockBuilder(Token::class)
            ->disableOriginalConstructor()
            ->setMethods(array('getType'))
            ->getMock();
        $token
            ->expects($this->once())
            ->method('getType')
            ->willReturn('othertype');
        $request = new Request();
        $request->headers->set('Authorization', "Bearer $jwtToken");
        $tokenService = $this->getMockBuilder(ShaTokenService::class)
            ->setMethods(array('parse'))
            ->getMock();
        $tokenService
            ->expects($this->any())
            ->method('parse')
            ->with($jwtToken)
            ->willReturn($token);

        $event = $this->getMockBuilder(GetResponseEvent::class)
            ->setMethods(array('getRequest', 'getRequestType'))
            ->disableOriginalConstructor()
            ->getMock();
        $event
            ->expects($this->any())
            ->method('getRequestType')
            ->willReturn(HttpKernel::MASTER_REQUEST);
        $event
            ->expects($this->any())
            ->method('getRequest')
            ->willReturn($request);
        $listener = new MemberTokenListener();
        $this->setObjectAttribute($listener, 'tokenService', $tokenService);

        //act
        $listener->onRequest($event);

        //assert
        $this->assertNull($request->attributes->get('_authorizedToken'));
    }

    public function test_onRequest_token_parse_ok()
    {
        //arrange
        $jwtToken = 'aaa.bbb.ccc';
        $token = $this->getMockBuilder(Token::class)
            ->disableOriginalConstructor()
            ->setMethods(array('getType'))
            ->getMock();
        $token
            ->expects($this->once())
            ->method('getType')
            ->willReturn(MemberTokenRequest::TOKEN_TYPE);
        $request = new Request();
        $request->headers->set('Authorization', "Bearer $jwtToken");
        $tokenService = $this->getMockBuilder(ShaTokenService::class)
            ->setMethods(array('parse'))
            ->getMock();
        $tokenService
            ->expects($this->any())
            ->method('parse')
            ->with($jwtToken)
            ->willReturn($token);

        $event = $this->getMockBuilder(GetResponseEvent::class)
            ->setMethods(array('getRequest', 'getRequestType'))
            ->disableOriginalConstructor()
            ->getMock();
        $event
            ->expects($this->any())
            ->method('getRequestType')
            ->willReturn(HttpKernel::MASTER_REQUEST);
        $event
            ->expects($this->any())
            ->method('getRequest')
            ->willReturn($request);
        $listener = new MemberTokenListener();
        $this->setObjectAttribute($listener, 'tokenService', $tokenService);

        //act
        $listener->onRequest($event);

        //assert
        $this->assertEquals($token, $request->attributes->get('_authorizedToken'));
    }


}