<?php
namespace Widget\MemberBundle\Tests\Controller\BackendAPI;


use Backend\BaseBundle\Model\SiteUserQuery;
use Backend\BaseBundle\Tests\Fixture\BackendWebTestCase;
use Widget\MemberBundle\Model\Member;
use Widget\MemberBundle\Model\MemberQuery;

class MemberControllerTest extends BackendWebTestCase
{
    public function test_createAction_success()
    {
        //arrange
        $loginName = 'admin';
        $origin = 'http://localhost';
        $user = SiteUserQuery::create()->findOneByLoginName($loginName);
        $token = $this->createToken($user, $origin);

        $params = array(
            'name' => 'bubble_new',
            'email' => 'bubble_new@dgfactor.com.tw',
        );

        //act
        $this->client->request(
            'POST',
            $this->generateUrl('widget_member_backendapi_member_create', array()),
            array(),
            array(),
            array(
                'HTTP_ORIGIN' => $origin,
                'HTTP_AUTHORIZATION' => "Bearer $token",
            ),
            json_encode($params)
        );
        $response = $this->client->getResponse();
        $member = MemberQuery::create()
            ->findOneByEmail($params['email']);

        //assert
        $this->assertTrue($response->isOk());
        $this->assertEquals($params['name'], $member->getName());
        $this->assertEquals($params['email'], $member->getEmail());

        //reset
        $member->delete();
    }

    public function test_updateAction()
    {
        //arrange
        $loginName = 'admin';
        $origin = 'http://localhost';
        $token = $this->createToken(SiteUserQuery::create()->findOneByLoginName($loginName), $origin);

        $params = array(
            'name' => '海免包包'
        );

        $member = MemberQuery::create()->findOneByEmail('bubble_test_create@dgfactor.com');
        $originMemberArray = $member->toArray(\BasePeer::TYPE_FIELDNAME);

        //act
        $this->client->request(
            'PUT',
            $this->generateUrl('widget_member_backendapi_member_update', array('id' => $member->getId())),
            array(),
            array(),
            array(
                'HTTP_ORIGIN' => $origin,
                'HTTP_AUTHORIZATION' => "Bearer $token",
            ),
            json_encode($params)
        );
        $response = $this->client->getResponse();
        $member->reload(true);

        //assert
        $this->assertTrue($response->isOk());
        $this->assertEquals($params['name'], $member->getName());

        //reset
        $member->fromArray($originMemberArray, \BasePeer::TYPE_FIELDNAME);
        $member->save();
    }

    public function test_searchAction()
    {
        //arrange
        $loginName = 'admin';
        $origin = 'http://localhost';
        $token = $this->createToken(SiteUserQuery::create()->findOneByLoginName($loginName), $origin);
        $params = array(
            'page' => 1,
            'sort' => array(
                'email' => 'asc'
            ),
            'search' => array(
                'email' => '%bubble_test_%',
            ),
        );

        //act
        $this->client->request(
            'GET',
            $this->generateUrl('widget_member_backendapi_member_search', $params),
            array(),
            array(),
            array(
                'HTTP_ORIGIN' => $origin,
                'HTTP_AUTHORIZATION' => "Bearer $token",
            )
        );
        $response = $this->client->getResponse();
        $result = json_decode($response->getContent(), true);

        //assert
        $this->assertTrue($response->isOk());
        $this->assertEquals(1, $result['pager']['page']);
        $this->assertEquals(1, $result['pager']['pages']);
        $this->assertEquals(1, $result['pager']['rows']);
        $this->assertEquals(1, count($result['data']));
        $this->assertEquals(array(
            'id',
            'email',
            'enabled',
            'locked',
            'member_info',
            'created_at',
            'updated_at',
        ), array_keys($result['data'][0]));
    }

    public function test_readAction()
    {
        //arrange
        $loginName = 'admin';
        $origin = 'http://localhost';
        $user = SiteUserQuery::create()->findOneByLoginName($loginName);
        $token = $this->createToken($user, $origin);

        $member = MemberQuery::create()->findOne();

        //act
        $this->client->request(
            'GET',
            $this->generateUrl('widget_member_backendapi_member_read', array('id'=>$member->getId())),
            array(),
            array(),
            array(
                'HTTP_ORIGIN' => $origin,
                'HTTP_AUTHORIZATION' => "Bearer $token",
            )
        );
        $response = $this->client->getResponse();

        //assert
        $this->assertTrue($response->isOk());

        //reset
    }
    
    public function test_deleteAction()
    {
        //arrange
        $loginName = 'admin';
        $origin = 'http://localhost';
        $user = SiteUserQuery::create()->findOneByLoginName($loginName);
        $token = $this->createToken($user, $origin);

        $member = MemberQuery::create()->findOneByEmail('bubble_test_create@dgfactor.com');

        //act
        $this->client->request(
            'DELETE',
            $this->generateUrl('widget_member_backendapi_member_delete', array('id'=>$member->getId())),
            array(),
            array(),
            array(
                'HTTP_ORIGIN' => $origin,
                'HTTP_AUTHORIZATION' => "Bearer $token",
            )
        );

        $response = $this->client->getResponse();

        //assert
        $this->assertTrue($response->isOk());
        $this->assertNull(MemberQuery::create()->findOneByEmail('bubble_test_create@dgfactor.com'));

        //reset

        $data = $member->toArray();
        $member = new Member();
        $member->fromArray($data);
        $member->save();
    }
}