<?php
namespace Widget\MemberBundle\Security;

use JMS\DiExtraBundle\Annotation\Inject;
use JMS\DiExtraBundle\Annotation\InjectParams;
use Widget\MemberBundle\Model;
use JMS\DiExtraBundle\Annotation\Service;
/**
 * @Service("member_manager.soldium_password")
 */
class SoldiumMemberManager extends AbstractMemberManager
{
    /** @var  MemberPasswordEncoderFactory */
    protected $encoderFactory;

    /**
     * @InjectParams({
     *     "encoderFactory" = @Inject("member_password_encoder_factory")
     * })
     */
    public function injectEncoderFactory(MemberPasswordEncoderFactory $encoderFactory)
    {
        $this->encoderFactory = $encoderFactory;
    }

    /**
     * @param Model\Member $member
     */
    protected function updatePassword(Model\Member $member)
    {
        $encryptPassword = $this->encoderFactory->getEncoder()->create($member->getPlainPassword());
        $member->setPassword($encryptPassword);
    }

    /**
     * @param Model\Member $member
     * @param $password
     * @return bool
     */
    protected function verifyPassword(Model\Member $member, $password)
    {
        return $this->encoderFactory->getEncoder()->verify($password, $member->getPassword());
    }
}