<?php
namespace Widget\MemberBundle\Security;

use JMS\DiExtraBundle\Annotation as DI;
use Windwalker\Crypt\Password;

/**
 * @DI\Service("member_password_encoder_factory")
 */
class MemberPasswordEncoderFactory
{
    protected $type;

    /**
     * @DI\InjectParams({
     *   "algorithm" = @DI\Inject("%member_password_algorithm%")
     * })
     */
    public function injectAlgorithm($algorithm)
    {
        $type = constant("Widget\MemberBundle\Security\MemberSoldiumPassword::".strtoupper($algorithm));
        $this->type = $type;
    }

    public function getEncoder()
    {
        return new MemberSoldiumPassword($this->type);
    }
}
