<?php
namespace Widget\MemberBundle\Security;

use Widget\MemberBundle\Model;
use Symfony\Component\Security\Core\Authentication\Token\UsernamePasswordToken;
use Symfony\Component\Security\Core\User\UserInterface;
use Symfony\Component\Security\Guard\GuardAuthenticatorHandler;
use Symfony\Component\HttpFoundation\Request;
use JMS\DiExtraBundle\Annotation\Service;
use JMS\DiExtraBundle\Annotation\Inject;
use JMS\DiExtraBundle\Annotation\InjectParams;
use Widget\MemberBundle\Service\DefaultGroupService;

/**
 * @Service("member_manager.old_password")
 */
class MemberManager extends AbstractMemberManager
{

    /** @var  \Symfony\Component\Security\Core\Encoder\EncoderFactory */
    protected $encoderFactory;

    /**
     * @InjectParams({
     *     "encoderFactory" = @Inject("security.encoder_factory")
     * })
     */
    public function injectService($encoderFactory)
    {
        $this->encoderFactory = $encoderFactory;
    }

    protected function getEncoder(Model\Member $member)
    {
        return $this->encoderFactory->getEncoder($member);
    }

    /**
     * @param Model\Member $member
     */
    protected function updatePassword(Model\Member $member)
    {
        $member->regenerateSalt();
        $encoder = $this->getEncoder($member);
        $member->setPassword($encoder->encodePassword($member->getPlainPassword(), $member->getSalt()));
    }

    /**
     * @param Model\Member $member
     * @param $password
     * @return bool
     */
    protected function verifyPassword(Model\Member $member, $password)
    {
        $encoder = $this->getEncoder($member);
        return $encoder->isPasswordValid($member->getPassword(), $password, $member->getSalt());
    }
}