<?php
namespace Widget\MemberBundle\Security;

use JMS\DiExtraBundle\Annotation\Inject;
use JMS\DiExtraBundle\Annotation\InjectParams;
use Widget\MemberBundle\Model\Member;
use Widget\MemberBundle\Service\DefaultGroupService;

abstract class AbstractMemberManager implements MemberManagerInterface
{

    /** @var  DefaultGroupService */
    protected $defaultGroupService;

    /**
     * @InjectParams({
     *     "defaultGroupService" = @Inject("widget.member_bundle.service.default_group_service")
     * })
     */
    public function injectDefaultGroupService(DefaultGroupService $defaultGroupService)
    {
        $this->defaultGroupService = $defaultGroupService;
    }


    public function updateMember(Member $member, \PropelPDO $con = null)
    {
        if($member->getPlainPassword() !== null){
            $this->updatePassword($member);
        }
        $member->save($con);
    }

    public function createMember(Member $member, \PropelPDO $con = null)
    {
        $this->updateMember($member, $con);
        $this->defaultGroupService->setMemberDefaultGroup($member, $con);
    }

    public function verifyMember(Member $member, $password)
    {
        if(!$member->getEnabled() || $member->getLocked()){
            return false;
        }
        return $this->verifyPassword($member, $password);
    }

    abstract protected function updatePassword(Member $member);
    abstract protected function verifyPassword(Member $member, $password);
}