module.exports =
{
  "list": {
    "id": {
      "label": "#",
      "type": "id",
      "sort": true
    },
    "email": {
      "label": "index.member.email",
      "type": "text",
      "sort": true,
      "search": true
      searchConfig:
        key: "email"
        like: true
        type: "text"
    },
    "member_info.name": {
      "label": "form.label.edit.member_info.name",
      "type": "text",
    }
    "enabled": {
      "label": "index.member.enabled",
      "type": "checkbox",
      "sort": true,
      "batch": true
      config:
        value:
          true: 1
          false: 0
      batchSetting: [
        { label: 'index.member.enable', value: true }
        { label: 'index.member.disable', value: false }
      ]
    },
    "created_at": {
      "label": "index.member.created_at",
      "type": "datetime-local",
      "sort": true
      defaultSorting: 'desc'
    },
    "updated_at": {
      "label": "index.member.updated_at",
      "type": "datetime-local"
      "sort": true
    },
  },
  "extra": [
    {
      "name": "new",
      "label": "form.button.new",
      "roles": ["ROLE_MEMBER_WRITE"]
      "route": 'member-new'
    },
    {
      "name": "quick_search",
      "label": "action.quick",
      "roles": ["ROLE_MEMBER_WRITE"]
      component: require 'components/backendbase/partial/list/extra/quicksearch.vue'
      config:
        key: 'enabled'
        apiName: 'member'
        status: [
          { label: 'index.member.quick_search.all', value: 'all' }
          { label: 'index.member.quick_search.enabled', value: true }
          { label: 'index.member.quick_search.disabled', value: false }
        ]
    }
  ],
  "action": [
    {
      "name": "view",
      "label": "action.view",
      "roles": ["ROLE_MEMBER_READ"]
      "route": 'member-view'
    }
    {
      "name": "edit",
      "label": "action.edit",
      "roles": ["ROLE_MEMBER_WRITE"]
      "route": 'member-edit'
    }
    {
      "roles": ["ROLE_MEMBER_READ", "ROLE_ORDER_READ", "ROLE_ORDER_WRITE"]
      "component": require 'components/widgetmember/customize/list/order.vue'
    }
  ]
}