module.exports =
{
  "list": {
    "id": {
      "label": "#",
      "type": "id",
      "sort": true
    },
    "name": {
      "label": "index.group.name",
      "type": "text",
      "sort": true,
      "quick": true,
      "search": true
      searchConfig:
        key: "name"
        like: true
        type: "text"
    },
    "created_at": {
      "label": "index.group.created_at",
      "type": "datetime-local",
      "sort": true
      defaultSorting: 'desc'
    },
    "updated_at": {
      "label": "index.group.updated_at",
      "type": "datetime-local"
    },
  },
  "extra": [
    {
      "name": "new",
      "label": "form.button.new",
      "roles": ["ROLE_MEMBER_WRITE"]
      "route": 'group-new'
    },
  ],
  "action": [
    {
      "name": "edit",
      "label": "action.edit",
      "roles": ["ROLE_MEMBER_WRITE"]
      "route": 'group-edit'
    },
    {
      "name": "delete",
      "label": "action.delete",
      "roles": ["ROLE_MEMBER_WRITE"]
      "component": require 'components/backendbase/partial/list/table/actions/delete.vue'
    }
  ]
}