module.exports = (api) ->
  api.group =
    search: (data) ->
      api.request "GET", "/groups", data
    create: (data) ->
      api.request "POST", "/groups", data
    read: (id) ->
      api.request "GET", "/group/#{id}"
    update: (id, data) ->
      api.request  "PUT", "/group/#{id}", data
    delete: (id) ->
      api.request  "DELETE", "/group/#{id}"
    batch: (ids, action, column) ->
      api.request  "PUT", "/groups",
        ids: ids
        action: action
        column: column
    getMembers: () ->
      api.request "GET", "/members/all"
    membergroup: (id, data) ->
      api.request "POST", "/group/#{id}/membergroup", data
    checkDiscount: () ->
      api.request "GET", "/group/check/discountbundle"
    getDiscountGroups: () ->
      api.request "GET", "/discountgroups/all"
    discountGroup: (id, data) ->
      api.request "POST", "/discountgroup/#{id}/group", data      