<?php
namespace Widget\MemberBundle\Model;

use Backend\BaseBundle\Security\SecurityEncoderInterface;
use Symfony\Component\Security\Core\User\UserInterface;
use Widget\MemberBundle\Model\om\BaseMember;

class Member extends BaseMember implements SecurityEncoderInterface, UserInterface
{
    protected $plainPassword;

    public function setPlainPassword($plainPassword)
    {
        $this->plainPassword = $plainPassword;
        return $this;
    }

    public function getPlainPassword()
    {
        return $this->plainPassword;
    }

    public function regenerateSalt()
    {
        $this->setSalt(base_convert(sha1(uniqid(mt_rand(), true)), 16, 36));
        return $this;
    }

    public function regenerateConfirmToken($ttl = 86400)
    {
        $this->setConfirmToken(base_convert(sha1(uniqid(mt_rand(), true)), 16, 36));
        $this->setTokenExpiredAt(time() + $ttl);
        return $this;
    }

    /**
     * Returns the username used to authenticate the user.
     *
     * @return string The username
     */
    public function getUsername()
    {
        return $this->getName();
    }

    /**
     * Removes sensitive data from the user.
     *
     * This is important if, at any given point, sensitive information like
     * the plain-text password is stored on this object.
     */
    public function eraseCredentials()
    {
        $this->plainPassword = null;
    }
}
