<?php
namespace Widget\MemberBundle\EventListener;

use Backend\BaseBundle\Token\Service\TokenServiceInterface;
use JMS\DiExtraBundle\Annotation as DI;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpKernel\Event\GetResponseEvent;
use Symfony\Component\HttpKernel\HttpKernel;
use JMS\DiExtraBundle\Annotation\Service;
use Widget\MemberBundle\Token\MemberTokenRequest;

/**
 * @Service()
 */
class MemberTokenListener
{

    /** @var  TokenServiceInterface */
    protected $tokenService;

    /**
     * @DI\InjectParams()
     */
    public function injectTokenService(TokenServiceInterface $tokenService)
    {
        $this->tokenService = $tokenService;
    }

    /**
     * @DI\Observe("kernel.request")
     */
    public function onRequest(GetResponseEvent $event)
    {
        if (HttpKernel::MASTER_REQUEST != $event->getRequestType()) {
            return;
        }

        $request = $event->getRequest();
        $auth = $request->headers->get('Authorization');

        if($auth == null){
            return;
        }

        if(!(preg_match('/^Bearer\s+(.*)$/i', $auth, $match))){
            return;
        }

        if(!($token = $this->tokenService->parse($match[1])) || $token->getType() != MemberTokenRequest::TOKEN_TYPE){
            return null;
        }

        $request->attributes->set('_authorizedToken', $token);
    }

}