<?php

namespace Widget\MemberBundle\DependencyInjection;

use Symfony\Component\Config\Definition\Builder\TreeBuilder;
use Symfony\Component\Config\Definition\ConfigurationInterface;

/**
 * This is the class that validates and merges configuration from your app/config files.
 *
 * To learn more see {@link http://symfony.com/doc/current/cookbook/bundles/configuration.html}
 */
class Configuration implements ConfigurationInterface
{
    /**
     * {@inheritdoc}
     */
    public function getConfigTreeBuilder()
    {
        $treeBuilder = new TreeBuilder();
        $rootNode = $treeBuilder->root('widget_member');
        $rootNode
            ->children()
            ->scalarNode('config_service')->defaultValue('widget_member.config.setup')->end()
            ->scalarNode('member_manager')->defaultValue('member_manager.old_password')->end()
            ->end()
        ;

        return $treeBuilder;
    }
}
