<?php

namespace Widget\MemberBundle\Controller\BackendAPI;

use Backend\BaseBundle\Controller\BackendAPI\BaseBackendAPIController;
use Backend\BaseBundle\Form\Type\APIFormTypeItem;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Method;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Security;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\Validator\Constraints\NotBlank;
use Symfony\Component\Validator\Constraints\Regex;
use Widget\MemberBundle\Model\MemberInfo;
use Widget\MemberBundle\Model\MemberInfoQuery;

/**
 * @Route("/memberinfo")
 * @Security("has_role_or_superadmin('ROLE_SUPERADMIN')")
 */
class MemberInfoController extends BaseBackendAPIController
{

    /**
     * 欄位表單設定
     * 主要是USER送過來的欄位
     * @return APIFormTypeItem[]
     */
    protected function getFormConfig()
    {
        return array(
            new APIFormTypeItem('id'),
            (new APIFormTypeItem('name')),
            (new APIFormTypeItem('phone')),
            (new APIFormTypeItem('email')),
            new APIFormTypeItem('phone2'),
            new APIFormTypeItem('zip'),
            new APIFormTypeItem('address'),
        );
    }

    /**
     * 新增
     * @Route("s")
     * @Method({"POST"})
     * @Security("has_role_or_superadmin('ROLE_SUPERADMIN')")
     */
    public function createAction(Request $request)
    {
        return $this->doProcessForm(new MemberInfo(), $request->getContent());
    }

    /**
     * 更新
     * @Route("/{id}")
     * @Method({"PUT"})
     * @Security("has_role_or_superadmin('ROLE_SUPERADMIN')")
     */
    public function updateAction(Request $request, $id)
    {
        $memberInfo = MemberInfoQuery::create()->filterById($id)->findOneOrCreate();
        return $this->doProcessForm($memberInfo, $request->getContent());
    }
}