<?php

namespace Widget\MemberBundle\Controller\BackendAPI;

use Backend\BaseBundle\Controller\API\BaseController;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Method;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Security;
use Widget\MemberBundle\Model\Member;
use Widget\MemberBundle\Model\MemberQuery;
use Widget\OrderBundle\Model\Order;
use Widget\OrderBundle\Model\OrderQuery;

/**
 * @Route("/member")
 * @Security("has_role_or_superadmin('ROLE_MEMBER')")
 */
class MemberDashboardController extends BaseController
{
    /**
     *
     * @Route("s/dashboard")
     * @Method({"GET"})
     * @Security("has_role_or_superadmin('ROLE_MEMBER_READ')")
     */
    public function dashBoardAction()
    {
        $statisticsData = array(
            'newSignup' => $this->getNewSignup(),
            // 最近一個月新加入會員數
            'newSignupOfLastMonth' => $this->getNewSignupOfLastMonth(),
            // 最近有消費的會員使用者(會員/非會員)
            'recentShopping' => $this->getRecentShopping(),
            'total' => $this->getMemberTotal()
        );
        return $this->createJsonResponse($statisticsData);
    }

    protected function getNewSignup()
    {
        $memberList = MemberQuery::create()
            ->leftJoinWithMemberInfo()
            ->orderByCreatedAt(\Criteria::DESC)
            ->limit(5)
            ->find();

        return $this->getSerializerArray($memberList);
    }

    protected function getNewSignupOfLastMonth()
    {
        $members = MemberQuery::create()->find();
        $newSignupOfLastMonth = 0;
        $timeIntervalTimestamp = $this->getTimeIntervalTimestamp();

        /** @var Member $member */
        foreach ($members as $member) {
            if ( $timeIntervalTimestamp < $member->getCreatedAt()->getTimestamp() ) {
                $newSignupOfLastMonth++;
            }
        }
        return $newSignupOfLastMonth;
    }

    protected function getRecentShopping()
    {
        if (!class_exists(Order::class)) {
            return null;
        }

        $memberIds = array();
        $orders = OrderQuery::create()
            ->filterByCreatedAt(array('min' => $this->getTimeIntervalTimestamp()))
            ->find();
        /** @var Order $order */
        foreach ($orders as $order){
            $memberIds[] = $order->getMemberId();
        }
        $members = MemberQuery::create()
            ->leftJoinWithMemberInfo()
            ->findPks($memberIds);
        return $this->getSerializerArray($members);
    }

    protected function getTimeIntervalTimestamp()
    {
        return strtotime("-1 month");
    }

    protected function getMemberTotal()
    {
        return count(MemberQuery::create()->find());
    }

    protected function getSerializerArray($object)
    {
        return json_decode($this->createJsonSerializeResponse($object, array('list'))->getContent(), true);
    }
}