<?php

namespace Widget\MemberBundle\Command;

use Backend\BaseBundle\Model\SiteQuery;
use Symfony\Bundle\FrameworkBundle\Command\ContainerAwareCommand;
use Symfony\Component\Console\Input\InputArgument;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;
use Widget\MemberBundle\Model\GroupQuery;
use Widget\MemberBundle\Model\Member;
use Widget\MemberBundle\Model\MemberQuery;

class MemberDefaultGroupCommand extends ContainerAwareCommand
{
    protected function configure()
    {
        $this
            ->setName('dgfactor:member:defaultGroup')
            ->setDescription('無所屬群組的會員設定群組')
            ->setDefinition(array(
                new InputArgument('groupname', InputArgument::REQUIRED, '會員群組名稱'),
            ))
            ->setHelp(<<<EOT
The <info>dgfactor:member:defaultGroup</info> 無所屬群組的會員設定群組

  <info>php app/console dgfactor:order:expire dgfactor</info>
EOT
            );
    }

    /**
     * @see Command
     */
    protected function execute(InputInterface $input, OutputInterface $output)
    {
        $groupName = $input->getArgument('groupname');

        $group = GroupQuery::create()->findOneByName($groupName);

        if (!$group) {
            $output->writeln(sprintf('找不到會員群組 <error>%s</error>', $groupName));
            return;
        }

        // process
        $memberNotGroup = MemberQuery::create()
            ->find();
        /** @var Member $member */
        foreach ($memberNotGroup as $member) {
            if ($member->getGroups()->count() == 0) {
                $member
                    ->addGroup($group)
                    ->save();
            }
        }


        $output->writeln(sprintf('無群組會員已所屬 <comment>%s</comment> 群組', $groupName));
    }

    /**
     * @see Command
     */
    protected function interact(InputInterface $input, OutputInterface $output)
    {
        if (!$input->getArgument('groupname')) {
            $functions = $this->getHelper('dialog')->askAndValidate(
                $output,
                '會員群組名稱:',
                function($functions) {
                    if (empty($functions)) {
                        throw new \Exception('會員群組名稱不能為空');
                    }

                    return $functions;
                }
            );
            $input->setArgument('groupname', $functions);
        }

    }
}