<?php
namespace Widget\MemberBundle\Tests\Service;


use Backend\BaseBundle\Tests\Fixture\BaseKernelTestCase;
use Widget\MemberBundle\Service\RecaptchaEnableChecker;

class RecaptchaEnableCheckerTest extends BaseKernelTestCase
{
    public function test_default_config()
    {
        //arrange
        //act
        $checker = $this->container->get('recaptcha.enable.checker');

        //assert
        $this->assertEquals(array(
            'register' => false,
            'forgetpassword' => false,
            'login' => false,
            'resendverifymail' => false,
        ), $this->getObjectAttribute($checker, 'config'));
    }

    public function test_isEnable_null_config()
    {
        //arrange
        $recaptchaEnableChecker = new RecaptchaEnableChecker();

        //act
        $result = $recaptchaEnableChecker->isEnable('test');

        //assert
        $this->assertFalse($result);
    }

    public function test_isEnable_not_exist_config_option()
    {
        //arrange
        $config = array('bad' => false);
        $recaptchaEnableChecker = new RecaptchaEnableChecker();
        $this->setObjectAttribute($recaptchaEnableChecker, 'config', $config);

        //act
        $result = $recaptchaEnableChecker->isEnable('test');

        //assert
        $this->assertFalse($result);
    }

    public function test_isEnable_config_false()
    {
        //arrange
        $config = array('test' => false);
        $recaptchaEnableChecker = new RecaptchaEnableChecker();
        $this->setObjectAttribute($recaptchaEnableChecker, 'config', $config);

        //act
        $result = $recaptchaEnableChecker->isEnable('test');

        //assert
        $this->assertFalse($result);
    }

    public function test_isEnable_config_true()
    {
        //arrange
        $config = array('test' => true);
        $recaptchaEnableChecker = new RecaptchaEnableChecker();
        $this->setObjectAttribute($recaptchaEnableChecker, 'config', $config);

        //act
        $result = $recaptchaEnableChecker->isEnable('test');

        //assert
        $this->assertTrue($result);
    }

}