<?php
namespace Widget\MemberBundle\Tests\Service;

use Backend\BaseBundle\Tests\Fixture\BaseTestCase;
use GuzzleHttp\Client;
use Widget\MemberBundle\Service\OAuthService;

class OAuthServiceTest extends BaseTestCase
{
    public function test_queryUserInfo_google()
    {
        //arrange
        $endpoint = 'google';
        $endpointUrl = 'https://www.googleapis.com/oauth2/v1/userinfo';
        $responseArray = array(
            'email' => 'shanhu@dgfactor.com'
        );

        $token = '12345';
        $response = $this->getMockBuilder(\stdClass::class)
            ->setMethods(array('getBody'))
            ->getMock();
        $response
            ->expects($this->once())
            ->method('getBody')
            ->willReturn(json_encode($responseArray));
        $service = $this->getMockBuilder(OAuthService::class)
            ->disableOriginalConstructor()
            ->setMethods(null)
            ->getMock();

        $client = $this->getMockBuilder(Client::class)
            ->disableOriginalConstructor()
            ->setMethods(array('request'))
            ->getMock();
        $client
            ->expects($this->once())
            ->method('request')
            ->willReturnCallback(function($method, $url, $params) use($endpointUrl, $token, $response){
                $this->assertEquals('GET', $method);
                $this->assertEquals($endpointUrl, $url);
                $this->assertEquals(array('query' => array('access_token' => $token)), $params);
                return $response;
            });
        $this->setObjectAttribute($service, 'client', $client);

        //act
        $result = $service->queryUserInfo($endpoint, $token);

        //assert
        $this->assertEquals($responseArray, $result);
    }

    public function test_queryUserInfo_facebook()
    {
        //arrange
        $endpoint = 'facebook';
        $endpointUrl = 'https://graph.facebook.com/me';
        $responseArray = array(
            'email' => 'shanhu@dgfactor.com'
        );

        $token = '12345';
        $response = $this->getMockBuilder(\stdClass::class)
            ->setMethods(array('getBody'))
            ->getMock();
        $response
            ->expects($this->once())
            ->method('getBody')
            ->willReturn(json_encode($responseArray));
        $service = $this->getMockBuilder(OAuthService::class)
            ->disableOriginalConstructor()
            ->setMethods(null)
            ->getMock();

        $client = $this->getMockBuilder(Client::class)
            ->disableOriginalConstructor()
            ->setMethods(array('request'))
            ->getMock();
        $client
            ->expects($this->once())
            ->method('request')
            ->willReturnCallback(function($method, $url, $params) use($endpointUrl, $token, $response){
                $this->assertEquals('GET', $method);
                $this->assertEquals($endpointUrl, $url);
                $this->assertEquals(array('query' => array('access_token' => $token, 'fields' => 'email')), $params);
                return $response;
            });
        $this->setObjectAttribute($service, 'client', $client);

        //act
        $result = $service->queryUserInfo($endpoint, $token);

        //assert
        $this->assertEquals($responseArray, $result);
    }

    public function test_queryUserInfo_invalid()
    {
        //arrange
        $endpoint = 'badendpoint';
        $token = '12345';

        $client = $this->getMockBuilder(Client::class)
            ->disableOriginalConstructor()
            ->setMethods(array('request'))
            ->getMock();
        $client
            ->expects($this->never())
            ->method('request')
            ->willReturn(null);
        $service = $this->getMockBuilder(OAuthService::class)
            ->disableOriginalConstructor()
            ->setMethods(null)
            ->getMock();
        $this->setObjectAttribute($service, 'client', $client);

        //act
        $result = $service->queryUserInfo($endpoint, $token);

        //assert
        $this->assertNull($result);
    }
}