<?php
namespace Widget\MemberBundle\Service;

use JMS\DiExtraBundle\Annotation as DI;
use JMS\DiExtraBundle\Annotation\Inject;
use Symfony\Component\EventDispatcher\EventDispatcherInterface;
use Widget\MemberBundle\Event\TokenSignEvent;
use Widget\MemberBundle\Model\Member;
use Widget\MemberBundle\Token\MemberAuthToken;

/**
 * @DI\Service("widget_member.token.signer")
 */
class TokenService
{
    protected $secret;

    /** @var  EventDispatcherInterface */
    protected $eventDispatcher;

    /**
     * @DI\InjectParams({
     *    "secret" = @Inject("%secret%")
     * })
     */
    public function injectSecret($secret)
    {
        $this->secret = $secret;
    }

    /**
     * @DI\InjectParams()
     */
    public function injectEventDispatcher(EventDispatcherInterface $eventDispatcher)
    {
        $this->eventDispatcher = $eventDispatcher;
    }

    public function sign($issuer, $audience, Member $member)
    {
        $event = new TokenSignEvent($member);
        $this->eventDispatcher->dispatch(TokenSignEvent::EVENT_NAME, $event);

        $token = new MemberAuthToken($this->secret, $issuer, $audience);
        $token->setMember($member);
        foreach ($event->getData() as $key => $value){
            $token->set($key, $value);
        }
        $jwtToken = $token->getJWTToken();
        return $jwtToken;
    }
}