<?php
namespace Widget\MemberBundle\Service;

use JMS\DiExtraBundle\Annotation as DI;

/**
 * @DI\Service("recaptcha.enable.checker")
 */
class RecaptchaEnableChecker
{
    protected $config;

    /**
     * @DI\InjectParams({
     *     "config" = @DI\Inject("%widget_member.recaptcha%", required=false)
     * })
     */
    public function injectConfig($config)
    {
        $this->config = $config;
    }

    /**
     * @param $function
     * @return bool
     */
    public function isEnable($function)
    {
        if(!is_array($this->config)){
            return false;
        }

        if(!isset($this->config[$function])){
            return false;
        }

        return (bool) $this->config[$function];
    }
}