<?php
namespace Widget\MemberBundle\Service;

use GuzzleHttp\Client;
use JMS\DiExtraBundle\Annotation\Service;

/**
 * 取得 Oauth2 API登入的會員資訊
 * @Service("widget_member.oauth")
 */
class OAuthService
{
    protected $client;
    protected $endpoints = array(
        'google' => 'https://www.googleapis.com/oauth2/v1/userinfo',
        'facebook' => 'https://graph.facebook.com/me'
    );

    public function __construct()
    {
        $this->client = new Client();
    }

    public function queryUserInfo($endpoint, $accessToken)
    {
        if(!isset($this->endpoints[$endpoint])){
            return null;
        }
        $queryArray = array('access_token' => $accessToken);
        if($endpoint == 'facebook'){
            $queryArray = array_merge($queryArray, array('fields' => 'email'));
        }

        $res = $this->client->request('GET', $this->endpoints[$endpoint], array('query' => $queryArray));
        $responseData = json_decode($res->getBody(), true);
        return $responseData;
    }
}