<?php

namespace Widget\MemberBundle\Service;

use Backend\BaseBundle\Model\SiteConfigQuery;
use JMS\DiExtraBundle\Annotation as DI;
use Widget\MemberBundle\Model\GroupQuery;
use Widget\MemberBundle\Model\Member;

/**
 * @DI\Service("widget.member_bundle.service.default_group_service")
 */
class DefaultGroupService
{
    const DEFAULT_GROUP_NAME = '一般會員群組';

    protected function memberConfig()
    {
        $siteConfig = SiteConfigQuery::create()
            ->filterByName('widget_member')
            ->findOne();
        if ($siteConfig == null) {
            return array();
        }
        return $siteConfig->toArray(\BasePeer::TYPE_FIELDNAME);
    }

    public function setMemberDefaultGroup(Member $member, \PropelPDO $con = null)
    {
        $config = $this->memberConfig();
        $group = null;

        if (isset($config['config']['DefaultGroup'])){
            $group = GroupQuery::create()
                ->filterByName($config['config']['DefaultGroup'])
                ->orderByCreatedAt(\Criteria::ASC)
                ->findOne($con);
        }

        if (!$group) {
            $group = GroupQuery::create()
                ->filterByName(self::DEFAULT_GROUP_NAME)
                ->findOneOrCreate($con);
        }

        $member->addGroup($group);
        $member->save($con);
    }

}