<?php
namespace Widget\MemberBundle\Security;

use Widget\MemberBundle\Model;
use Symfony\Component\Security\Core\Authentication\Token\UsernamePasswordToken;
use Symfony\Component\Security\Core\User\UserInterface;
use Symfony\Component\Security\Guard\GuardAuthenticatorHandler;
use Symfony\Component\HttpFoundation\Request;
use JMS\DiExtraBundle\Annotation\Service;
use JMS\DiExtraBundle\Annotation\Inject;
use JMS\DiExtraBundle\Annotation\InjectParams;
use Widget\MemberBundle\Service\DefaultGroupService;

/**
 * @Service("member_manager")
 */
class MemberManager
{

    /** @var  \Symfony\Component\Security\Core\Encoder\EncoderFactory */
    protected $encoderFactory;

    /** @var  DefaultGroupService */
    protected $defaultGroupService;

    /**
     * @InjectParams({
     *     "encoderFactory" = @Inject("security.encoder_factory")
     * })
     */
    public function injectService($encoderFactory)
    {
        $this->encoderFactory = $encoderFactory;
    }

    /**
     * @InjectParams({
     *     "defaultGroupService" = @Inject("widget.member_bundle.service.default_group_service")
     * })
     */
    public function injectDefaultGroupService(DefaultGroupService $defaultGroupService)
    {
        $this->defaultGroupService = $defaultGroupService;
    }

    protected function getEncoder(Model\Member $member)
    {
        return $this->encoderFactory->getEncoder($member);
    }

    public function updateMember(Model\Member $member, \PropelPDO $con = null)
    {
        if($member->getPlainPassword() !== null){
            $member->regenerateSalt();
            $encoder = $this->getEncoder($member);
            $member->setPassword($encoder->encodePassword($member->getPlainPassword(), $member->getSalt()));
        }
        $member->save($con);
    }

    public function createMember(Model\Member $member, \PropelPDO $con = null)
    {
        $this->updateMember($member, $con);
        $this->defaultGroupService->setMemberDefaultGroup($member, $con);
    }

    public function verifyMember(Model\Member $member, $password)
    {
        if(!$member->getEnabled() || $member->getLocked()){
            return false;
        }
        $encoder = $this->getEncoder($member);
        return $encoder->isPasswordValid($member->getPassword(), $password, $member->getSalt());
    }
}