abstractEdit = require "components/backendbase/actions/abstract-edit.coffee"

class MemberEdit extends abstractEdit
  _init: () ->
    require("components/widgetmember/actions/api/member.coffee") @api
  injectConfig: () ->
    require 'components/widgetmember/config/edit/member.coffee'
# 取得資料
  _getData: (id) ->
    @api.member.read id
# 儲存表單
  save: () ->
    me = @
    @api.member.update @editSetting.dataRow.id, @editSetting.dataRow
    .then (result) ->
      return new Promise (subResolve, subReject) ->
        promises = []
        promises.push me.api.member.memberinfoUpdate me.editSetting.dataRow.id, me.editSetting.dataRow.member_info
        promises.push me.api.member.membergroup me.editSetting.dataRow.id, me.editSetting.dataRow
        Promise.all(promises).then (subResult) ->
          subResolve result
        .catch (subReason) ->
          subReject subReason
  create: () ->
    me = @
    @api.member.create @editSetting.dataRow
    .then (result) ->
      return new Promise (subResolve, subReject) ->
        promises = []
        promises.push me.api.member.memberinfoUpdate result.id, me.editSetting.dataRow.member_info
        promises.push me.api.member.membergroup result.id, me.editSetting.dataRow
        Promise.all(promises).then (subResult) ->
          subResolve result
        .catch (subReason) ->
          me.api.member.delete result.id
          subReject subReason
      .catch (error) ->
        console.log error
module.exports = (api, id) ->
  new MemberEdit(api, id)