module.exports = (api) ->
  api.member =
    search: (data) ->
      api.request "GET", "/members", data
    create: (data) ->
      api.request "POST", "/members", data
    read: (id) ->
      api.request "GET", "/member/#{id}"
    update: (id, data) ->
      api.request  "PUT", "/member/#{id}", data
    delete: (id) ->
      api.request  "DELETE", "/member/#{id}"
    batch: (ids, action, column, value) ->
      api.request  "PUT", "/members",
        ids: ids
        value: value
        action: action
        column: column
    getGroups: () ->
      api.request "GET", "/groups/all"
    membergroup: (id, data) ->
      api.request "POST", "/member/#{id}/membergroup", data
    memberinfoCreate: (data) ->
      api.request "POST", "/memberinfos", data
    memberinfoUpdate: (id, data) ->
      api.request "PUT", "/memberinfo/#{id}", data