<?php
namespace Widget\MemberBundle\EventListener;

use Lcobucci\JWT\Parser;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpKernel\Event\GetResponseEvent;
use Symfony\Component\HttpKernel\HttpKernel;
use JMS\DiExtraBundle\Annotation\Service;
use JMS\DiExtraBundle\Annotation\Tag;
use JMS\DiExtraBundle\Annotation\Inject;
use JMS\DiExtraBundle\Annotation\InjectParams;
use Widget\MemberBundle\Token\MemberAuthToken;


/**
 * @Service
 * @Tag("kernel.event_listener", attributes = {"public": false, "event": "kernel.request", "method": "onRequest"})
 */
class AuthTokenListener
{

    protected $secret;

    /**
     * @InjectParams({
     *    "secret" = @Inject("%secret%"),
     * })
     */
    public function injectSecret($secret)
    {
        $this->secret = $secret;
    }

    public function onRequest(GetResponseEvent $event)
    {
        if (HttpKernel::MASTER_REQUEST != $event->getRequestType()) {
            return;
        }

        $request = $event->getRequest();
        $auth = $request->headers->get('Authorization');

        if($auth == null){
            return;
        }

        if(!(preg_match('/^Bearer\s+(.*)$/i', $auth, $match))){
            return;
        }

        if(!($memberAuthToken = $this->parseToken($request, $match[1]))){
            return;
        }

        if(!($memberAuthToken->getJWTToken())){
            return;
        }

        $request->attributes->set('_authorizedToken', $memberAuthToken);
    }

    protected function parseToken(Request $request, $jwt)
    {
        $audience = $request->headers->get('origin', null);
        $issuer = "{$request->getScheme()}://{$request->getHttpHost()}";

        $memberAuthToken = new MemberAuthToken($this->secret, $issuer, $audience);
        $memberAuthToken->setJWTToken($jwt);
        return $memberAuthToken;
    }
}