<?php
namespace Widget\MemberBundle\Event;


use Symfony\Component\EventDispatcher\Event;
use Widget\MemberBundle\Model\Member;

class TokenSignEvent extends Event
{
    const EVENT_NAME = 'event.widget_member.token_sign';

    /** @var Member  */
    protected $member;

    protected $data = [];

    public function __construct(Member $member)
    {
        $this->member = $member;
    }

    /**
     * @return Member
     */
    public function getMember()
    {
        return $this->member;
    }

    public function appendData($key, $value)
    {
        $this->data[$key] = $value;
    }

    /**
     * @return array
     */
    public function getData()
    {
        return $this->data;
    }
}