<?php
namespace Widget\InvoiceBundle\Tests\Service;

use Backend\BaseBundle\Tests\Fixture\BaseKernelTestCase;
use Backend\BaseBundle\Token\Service\Token;
use Widget\InvoiceBundle\Model\InvoicePeer;
use Widget\InvoiceBundle\Service\OrderTokenInvoiceCreateRequest;

class OrderTokenInvoiceCreateRequestTest extends BaseKernelTestCase
{
    public function test___construct_bad_token_type()
    {
        //arrange
        $token = $this->getMockBuilder(Token::class)
            ->setMethods(array())
            ->disableOriginalConstructor()
            ->getMock();
        $this->expectException(\RuntimeException::class);

        //act
        $result = new OrderTokenInvoiceCreateRequest($token, array());

        //assert
    }

    public function test___construct()
    {
        //arrange
        $token = $this->getMockBuilder(Token::class)
            ->setMethods(array('isType'))
            ->disableOriginalConstructor()
            ->getMock();
        $token
            ->expects($this->once())
            ->method('isType')
            ->willReturn(true);
        $info = array(0, 1, 2, 3);

        //act
        $result = new OrderTokenInvoiceCreateRequest($token, $info);

        //assert
        $this->assertSame($token, $this->getObjectAttribute($result, 'token'));
        $this->assertEquals($info, $this->getObjectAttribute($result, 'invoiceInfo'));
    }

    public function test_getOrderInfo()
    {
        //arrange
        $orderData = array(
            'order' => array(0, 2, 4, 6, 8)
        );
        $token = $this->getMockBuilder(Token::class)
            ->setMethods(array('getData'))
            ->disableOriginalConstructor()
            ->getMock();
        $token
            ->expects($this->once())
            ->method('getData')
            ->willReturn($orderData);
        $orderTokenInvoiceCreateRequest = $this->getMockBuilder(OrderTokenInvoiceCreateRequest::class)
            ->setMethods()
            ->disableOriginalConstructor()
            ->getMock();
        $this->setObjectAttribute($orderTokenInvoiceCreateRequest, 'token', $token);

        //act
        $result = $orderTokenInvoiceCreateRequest->getOrderInfo();

        //assert
        $this->assertEquals($orderData['order'], $result);
    }

    public function test_getId()
    {
        //arrange
        $token = $this->getMockBuilder(Token::class)
            ->setMethods(array('getId'))
            ->disableOriginalConstructor()
            ->getMock();
        $token
            ->expects($this->once())
            ->method('getId')
            ->willReturn(12345);
        $orderTokenInvoiceCreateRequest = $this->getMockBuilder(OrderTokenInvoiceCreateRequest::class)
            ->setMethods()
            ->disableOriginalConstructor()
            ->getMock();
        $this->setObjectAttribute($orderTokenInvoiceCreateRequest, 'token', $token);

        //act
        $result = $orderTokenInvoiceCreateRequest->getId();

        //assert
        $this->assertEquals(12345, $result);
    }

    public function test_getEmail()
    {
        //arrange
        $invoiceInfo = array(
            'email' => 'ricky@dgfactor.com'
        );
        $orderTokenInvoiceCreateRequest = $this->getMockBuilder(OrderTokenInvoiceCreateRequest::class)
            ->setMethods()
            ->disableOriginalConstructor()
            ->getMock();
        $this->setObjectAttribute($orderTokenInvoiceCreateRequest, 'invoiceInfo', $invoiceInfo);

        //act
        $result = $orderTokenInvoiceCreateRequest->getEmail();

        //assert
        $this->assertEquals($invoiceInfo['email'], $result);
    }

    public function test_getEmail_null()
    {
        //arrange
        $invoiceInfo = array(
            'email' => 'ricky@dgfactor.com'
        );
        $orderTokenInvoiceCreateRequest = $this->getMockBuilder(OrderTokenInvoiceCreateRequest::class)
            ->setMethods()
            ->disableOriginalConstructor()
            ->getMock();
//        $this->setObjectAttribute($orderTokenInvoiceCreateRequest, 'invoiceInfo', $invoiceInfo);

        //act
        $result = $orderTokenInvoiceCreateRequest->getEmail();

        //assert
        $this->assertNull($result);
    }

    public function test_getDonateMark_e()
    {
        //arrange
        $invoiceInfo = array(
            'mark' => 'e'
        );
        $orderTokenInvoiceCreateRequest = $this->getMockBuilder(OrderTokenInvoiceCreateRequest::class)
            ->setMethods()
            ->disableOriginalConstructor()
            ->getMock();
        $this->setObjectAttribute($orderTokenInvoiceCreateRequest, 'invoiceInfo', $invoiceInfo);

        //act
        $result = $orderTokenInvoiceCreateRequest->getDonateMark();

        //assert
        $this->assertEquals(InvoicePeer::DONATE_MARK_CARRIER, $result);
    }

    public function test_getDonateMark_d()
    {
        //arrange
        $invoiceInfo = array(
            'mark' => 'd'
        );
        $orderTokenInvoiceCreateRequest = $this->getMockBuilder(OrderTokenInvoiceCreateRequest::class)
            ->setMethods()
            ->disableOriginalConstructor()
            ->getMock();
        $this->setObjectAttribute($orderTokenInvoiceCreateRequest, 'invoiceInfo', $invoiceInfo);

        //act
        $result = $orderTokenInvoiceCreateRequest->getDonateMark();

        //assert
        $this->assertEquals(InvoicePeer::DONATE_MARK_DONATE, $result);
    }

    public function test_getDonateMark_p()
    {
        //arrange
        $invoiceInfo = array(
            'mark' => 'p'
        );
        $orderTokenInvoiceCreateRequest = $this->getMockBuilder(OrderTokenInvoiceCreateRequest::class)
            ->setMethods()
            ->disableOriginalConstructor()
            ->getMock();
        $this->setObjectAttribute($orderTokenInvoiceCreateRequest, 'invoiceInfo', $invoiceInfo);

        //act
        $result = $orderTokenInvoiceCreateRequest->getDonateMark();

        //assert
        $this->assertEquals(InvoicePeer::DONATE_MARK_PAPER, $result);
    }

    public function test_getCarrierType_0()
    {
        //arrange
        $invoiceInfo = array(
            'carrierType' => '0'
        );
        $orderTokenInvoiceCreateRequest = $this->getMockBuilder(OrderTokenInvoiceCreateRequest::class)
            ->setMethods()
            ->disableOriginalConstructor()
            ->getMock();
        $this->setObjectAttribute($orderTokenInvoiceCreateRequest, 'invoiceInfo', $invoiceInfo);

        //act
        $result = $orderTokenInvoiceCreateRequest->getCarrierType();

        //assert
        $this->assertEquals('', $result);
    }

    public function test_getCarrierType_1()
    {
        //arrange
        $invoiceInfo = array(
            'carrierType' => '1'
        );
        $orderTokenInvoiceCreateRequest = $this->getMockBuilder(OrderTokenInvoiceCreateRequest::class)
            ->setMethods()
            ->disableOriginalConstructor()
            ->getMock();
        $this->setObjectAttribute($orderTokenInvoiceCreateRequest, 'invoiceInfo', $invoiceInfo);

        //act
        $result = $orderTokenInvoiceCreateRequest->getCarrierType();

        //assert
        $this->assertEquals('3J0002', $result);
    }

    public function test_getCarrierType_2()
    {
        //arrange
        $invoiceInfo = array(
            'carrierType' => '2'
        );
        $orderTokenInvoiceCreateRequest = $this->getMockBuilder(OrderTokenInvoiceCreateRequest::class)
            ->setMethods()
            ->disableOriginalConstructor()
            ->getMock();
        $this->setObjectAttribute($orderTokenInvoiceCreateRequest, 'invoiceInfo', $invoiceInfo);

        //act
        $result = $orderTokenInvoiceCreateRequest->getCarrierType();

        //assert
        $this->assertEquals('CQ0001', $result);
    }

    public function test_getCarrierType_default()
    {
        //arrange
        $invoiceInfo = array(
            'carrierType' => '2'
        );
        $orderTokenInvoiceCreateRequest = $this->getMockBuilder(OrderTokenInvoiceCreateRequest::class)
            ->setMethods()
            ->disableOriginalConstructor()
            ->getMock();
//        $this->setObjectAttribute($orderTokenInvoiceCreateRequest, 'invoiceInfo', $invoiceInfo);

        //act
        $result = $orderTokenInvoiceCreateRequest->getCarrierType();

        //assert
        $this->assertEquals('', $result);
    }

    public function test_getCarrierId()
    {
        //arrange
        $invoiceInfo = array(
            'carrierId' => '123'
        );
        $orderTokenInvoiceCreateRequest = $this->getMockBuilder(OrderTokenInvoiceCreateRequest::class)
            ->setMethods()
            ->disableOriginalConstructor()
            ->getMock();
        $this->setObjectAttribute($orderTokenInvoiceCreateRequest, 'invoiceInfo', $invoiceInfo);

        //act
        $result = $orderTokenInvoiceCreateRequest->getCarrierId();

        //assert
        $this->assertEquals('123', $result);
    }

    public function test_getCarrierId_default()
    {
        //arrange
        $invoiceInfo = array(
            'carrierId' => '123'
        );
        $orderTokenInvoiceCreateRequest = $this->getMockBuilder(OrderTokenInvoiceCreateRequest::class)
            ->setMethods()
            ->disableOriginalConstructor()
            ->getMock();
//        $this->setObjectAttribute($orderTokenInvoiceCreateRequest, 'invoiceInfo', $invoiceInfo);

        //act
        $result = $orderTokenInvoiceCreateRequest->getCarrierId();

        //assert
        $this->assertEquals('', $result);
    }

    public function test_getLoveCode()
    {
        //arrange
        $invoiceInfo = array(
            'loveCode' => '123'
        );
        $orderTokenInvoiceCreateRequest = $this->getMockBuilder(OrderTokenInvoiceCreateRequest::class)
            ->setMethods()
            ->disableOriginalConstructor()
            ->getMock();
        $this->setObjectAttribute($orderTokenInvoiceCreateRequest, 'invoiceInfo', $invoiceInfo);

        //act
        $result = $orderTokenInvoiceCreateRequest->getLoveCode();

        //assert
        $this->assertEquals('123', $result);
    }

    public function test_getLoveCode_default()
    {
        //arrange
        $invoiceInfo = array(
            'loveCode' => '123'
        );
        $orderTokenInvoiceCreateRequest = $this->getMockBuilder(OrderTokenInvoiceCreateRequest::class)
            ->setMethods()
            ->disableOriginalConstructor()
            ->getMock();
//        $this->setObjectAttribute($orderTokenInvoiceCreateRequest, 'invoiceInfo', $invoiceInfo);

        //act
        $result = $orderTokenInvoiceCreateRequest->getLoveCode();

        //assert
        $this->assertEquals('', $result);
    }

    public function test_getIdentifier()
    {
        //arrange
        $invoiceInfo = array(
            'companyId' => '123'
        );
        $orderTokenInvoiceCreateRequest = $this->getMockBuilder(OrderTokenInvoiceCreateRequest::class)
            ->setMethods()
            ->disableOriginalConstructor()
            ->getMock();
        $this->setObjectAttribute($orderTokenInvoiceCreateRequest, 'invoiceInfo', $invoiceInfo);

        //act
        $result = $orderTokenInvoiceCreateRequest->getIdentifier();

        //assert
        $this->assertEquals('123', $result);
    }

    public function test_getIdentifier_default()
    {
        //arrange
        $invoiceInfo = array(
            'companyId' => '123'
        );
        $orderTokenInvoiceCreateRequest = $this->getMockBuilder(OrderTokenInvoiceCreateRequest::class)
            ->setMethods()
            ->disableOriginalConstructor()
            ->getMock();
//        $this->setObjectAttribute($orderTokenInvoiceCreateRequest, 'invoiceInfo', $invoiceInfo);

        //act
        $result = $orderTokenInvoiceCreateRequest->getIdentifier();

        //assert
        $this->assertEquals('', $result);
    }

    public function test_getName()
    {
        //arrange
        $invoiceInfo = array(
            'companyName' => '123'
        );
        $orderTokenInvoiceCreateRequest = $this->getMockBuilder(OrderTokenInvoiceCreateRequest::class)
            ->setMethods()
            ->disableOriginalConstructor()
            ->getMock();
        $this->setObjectAttribute($orderTokenInvoiceCreateRequest, 'invoiceInfo', $invoiceInfo);

        //act
        $result = $orderTokenInvoiceCreateRequest->getName();

        //assert
        $this->assertEquals('123', $result);
    }

    public function test_getName_default()
    {
        //arrange
        $invoiceInfo = array(
            'companyName' => '123'
        );
        $orderTokenInvoiceCreateRequest = $this->getMockBuilder(OrderTokenInvoiceCreateRequest::class)
            ->setMethods()
            ->disableOriginalConstructor()
            ->getMock();
//        $this->setObjectAttribute($orderTokenInvoiceCreateRequest, 'invoiceInfo', $invoiceInfo);

        //act
        $result = $orderTokenInvoiceCreateRequest->getName();

        //assert
        $this->assertEquals('', $result);
    }

    public function test_getZip()
    {
        //arrange
        $invoiceInfo = array(
            'buyerZip' => '123'
        );
        $orderTokenInvoiceCreateRequest = $this->getMockBuilder(OrderTokenInvoiceCreateRequest::class)
            ->setMethods()
            ->disableOriginalConstructor()
            ->getMock();
        $this->setObjectAttribute($orderTokenInvoiceCreateRequest, 'invoiceInfo', $invoiceInfo);

        //act
        $result = $orderTokenInvoiceCreateRequest->getZip();

        //assert
        $this->assertEquals('123', $result);
    }

    public function test_getZip_default()
    {
        //arrange
        $invoiceInfo = array(
            'buyerZip' => '123'
        );
        $orderTokenInvoiceCreateRequest = $this->getMockBuilder(OrderTokenInvoiceCreateRequest::class)
            ->setMethods()
            ->disableOriginalConstructor()
            ->getMock();
//        $this->setObjectAttribute($orderTokenInvoiceCreateRequest, 'invoiceInfo', $invoiceInfo);

        //act
        $result = $orderTokenInvoiceCreateRequest->getZip();

        //assert
        $this->assertEquals('', $result);
    }


    public function test_getAddress()
    {
        //arrange
        $invoiceInfo = array(
            'buyerAddress' => '123'
        );
        $orderTokenInvoiceCreateRequest = $this->getMockBuilder(OrderTokenInvoiceCreateRequest::class)
            ->setMethods()
            ->disableOriginalConstructor()
            ->getMock();
        $this->setObjectAttribute($orderTokenInvoiceCreateRequest, 'invoiceInfo', $invoiceInfo);

        //act
        $result = $orderTokenInvoiceCreateRequest->getAddress();

        //assert
        $this->assertEquals('123', $result);
    }

    public function test_getAddress_default()
    {
        //arrange
        $invoiceInfo = array(
            'buyerAddress' => '123'
        );
        $orderTokenInvoiceCreateRequest = $this->getMockBuilder(OrderTokenInvoiceCreateRequest::class)
            ->setMethods()
            ->disableOriginalConstructor()
            ->getMock();
//        $this->setObjectAttribute($orderTokenInvoiceCreateRequest, 'invoiceInfo', $invoiceInfo);

        //act
        $result = $orderTokenInvoiceCreateRequest->getAddress();

        //assert
        $this->assertEquals('', $result);
    }
}